/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.ThreadUtils;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadLocalStateCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLocalStateCleaner.class);
    public static final ThreadLocalStateCleaner INSTANCE = new ThreadLocalStateCleaner();
    private static final Method GET_THREADLOCAL_MAP_METHOD = MethodUtils.getMatchingMethod(ThreadLocal.class, "getMap", Thread.class);
    private volatile Method removeThreadlocalMethod;
    private volatile Method getThreadlocalEntryMethod;
    private volatile Field threadLocalEntryValueField;

    private ThreadLocalStateCleaner() {
    }

    public <T> void cleanupThreadLocal(ThreadLocal<?> threadLocal, Thread thread, BiConsumer<Thread, T> cleanedValueListener) {
        Objects.nonNull(threadLocal);
        Objects.nonNull(thread);
        try {
            Object threadLocalMap = GET_THREADLOCAL_MAP_METHOD.invoke(threadLocal, thread);
            if (threadLocalMap != null) {
                if (cleanedValueListener != null) {
                    this.callCleanedValueListener(threadLocal, thread, cleanedValueListener, threadLocalMap);
                }
                if (this.removeThreadlocalMethod == null) {
                    this.removeThreadlocalMethod = MethodUtils.getMatchingMethod(threadLocalMap.getClass(), "remove", ThreadLocal.class);
                    this.removeThreadlocalMethod.setAccessible(true);
                }
                this.removeThreadlocalMethod.invoke(threadLocalMap, threadLocal);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.warn("Cannot cleanup thread local", (Throwable)e);
        }
    }

    private <T> void callCleanedValueListener(ThreadLocal<?> threadLocal, Thread thread, BiConsumer<Thread, T> cleanedValueListener, Object threadLocalMap) throws IllegalAccessException, InvocationTargetException {
        T currentValue = this.getCurrentValue(threadLocal, threadLocalMap);
        if (currentValue != null) {
            cleanedValueListener.accept(thread, (Thread)currentValue);
        }
    }

    public <T> T getThreadLocalValue(ThreadLocal<?> threadLocal, Thread thread) throws InvocationTargetException, IllegalAccessException {
        Objects.nonNull(threadLocal);
        Objects.nonNull(thread);
        Object threadLocalMap = GET_THREADLOCAL_MAP_METHOD.invoke(threadLocal, thread);
        if (threadLocalMap != null) {
            return this.getCurrentValue(threadLocal, threadLocalMap);
        }
        return null;
    }

    private <T> T getCurrentValue(ThreadLocal<?> threadLocal, Object threadLocalMap) throws IllegalAccessException, InvocationTargetException {
        Object entry;
        if (this.getThreadlocalEntryMethod == null) {
            this.getThreadlocalEntryMethod = MethodUtils.getMatchingMethod(threadLocalMap.getClass(), "getEntry", ThreadLocal.class);
            this.getThreadlocalEntryMethod.setAccessible(true);
        }
        if ((entry = this.getThreadlocalEntryMethod.invoke(threadLocalMap, threadLocal)) != null) {
            if (this.threadLocalEntryValueField == null) {
                this.threadLocalEntryValueField = FieldUtils.getField(entry.getClass(), "value", true);
            }
            return (T)this.threadLocalEntryValueField.get(entry);
        }
        return null;
    }

    public <T> void cleanupThreadLocal(ThreadLocal<?> threadLocal, BiConsumer<Thread, T> cleanedValueListener) {
        Objects.nonNull(threadLocal);
        for (Thread thread : ThreadUtils.getAllThreads()) {
            this.cleanupThreadLocal(threadLocal, thread, cleanedValueListener);
        }
    }

    static {
        GET_THREADLOCAL_MAP_METHOD.setAccessible(true);
    }
}

