/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.internal.BoundedLinkedHashSet;
import org.jclouds.atmos.xml.ListDirectoryResponseHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;

@Singleton
public class ParseDirectoryListFromContentAndHeaders
implements Function<HttpResponse, BoundedSet<DirectoryEntry>> {
    private final ParseSax.Factory factory;
    private final Provider<ListDirectoryResponseHandler> listHandlerProvider;

    @Inject
    ParseDirectoryListFromContentAndHeaders(ParseSax.Factory factory, Provider<ListDirectoryResponseHandler> listHandlerProvider) {
        this.factory = Preconditions.checkNotNull(factory, "factory");
        this.listHandlerProvider = Preconditions.checkNotNull(listHandlerProvider, "listHandlerProvider");
    }

    @Override
    public BoundedSet<DirectoryEntry> apply(HttpResponse from) {
        Preconditions.checkNotNull(from, "http response");
        String token = from.getFirstHeaderOrNull("x-emc-token");
        return new BoundedLinkedHashSet<DirectoryEntry>((Iterable)this.factory.create(this.listHandlerProvider.get()).parse(from.getPayload().getInput()), token);
    }
}

