/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.filters;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.location.Provider;
import org.jclouds.s3.filters.RequestAuthorizeSignatureV2;

@Singleton
public class AWSRequestAuthorizeSignature
extends RequestAuthorizeSignatureV2 {
    @Inject
    public AWSRequestAuthorizeSignature(SignatureWire signatureWire, @Named(value="jclouds.aws.auth.tag") String authTag, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath, @Named(value="jclouds.aws.header.tag") String headerTag, @Provider Supplier<Credentials> creds, @TimeStamp org.apache.pulsar.jcloud.shade.jakarta.inject.Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils, DateService dateService) {
        super(signatureWire, authTag, isVhostStyle, servicePath, headerTag, creds, timeStampProvider, crypto, utils, dateService);
    }

    @Override
    protected HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        if (Queries.queryParser().apply(request.getEndpoint().getQuery()).containsKey("Signature")) {
            return request;
        }
        return super.replaceAuthorizationHeader(request, signature);
    }
}

