/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import java.net.URI;
import java.util.Properties;
import org.jclouds.azureblob.AzureBlobApiMetadata;
import org.jclouds.oauth.v2.config.CredentialType;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

public class AzureBlobProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return AzureBlobProviderMetadata.builder().fromProviderMetadata(this);
    }

    public AzureBlobProviderMetadata() {
        super(AzureBlobProviderMetadata.builder());
    }

    public AzureBlobProviderMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.put("oauth.endpoint", "https://login.microsoft.com/${jclouds.azureblob.tenantId}/oauth2/token");
        properties.put("jclouds.oauth.resource", "https://storage.azure.com");
        properties.put("jclouds.oauth.credential-type", CredentialType.CLIENT_CREDENTIALS_SECRET.toString());
        properties.put("jclouds.azureblob.account", "${jclouds.identity}");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("azureblob").name("Microsoft Azure Blob Service").apiMetadata(new AzureBlobApiMetadata()).endpoint("https://${jclouds.azureblob.account}.blob.core.windows.net").homepage(URI.create("http://www.microsoft.com/windowsazure/storage/")).console(URI.create("https://windows.azure.com/default.aspx")).linkedServices("azureblob", "azurequeue", "azuretable").iso3166Codes("US-TX", "US-IL", "IE-D", "SG", "NL-NH", "HK").defaultProperties(AzureBlobProviderMetadata.defaultProperties());
        }

        @Override
        public AzureBlobProviderMetadata build() {
            return new AzureBlobProviderMetadata(this);
        }

        @Override
        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

