/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain.internal;

import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.BlobType;
import org.jclouds.azureblob.domain.LeaseStatus;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public class MutableBlobPropertiesImpl
implements MutableBlobProperties {
    private BlobType type = BlobType.BLOCK_BLOB;
    private AccessTier tier;
    private LeaseStatus leaseStatus = LeaseStatus.UNLOCKED;
    private String name;
    private String container;
    private URI url;
    private Date lastModified;
    private String eTag;
    private MutableContentMetadata contentMetadata;
    private Map<String, String> metadata = Maps.newHashMap();

    public MutableBlobPropertiesImpl() {
        this.contentMetadata = new BaseMutableContentMetadata();
    }

    public MutableBlobPropertiesImpl(BlobProperties from) {
        this.contentMetadata = new BaseMutableContentMetadata();
        this.name = from.getName();
        this.container = from.getContainer();
        this.url = from.getUrl();
        this.lastModified = from.getLastModified();
        this.eTag = from.getETag();
        this.metadata.putAll(from.getMetadata());
        HttpUtils.copy(from.getContentMetadata(), this.contentMetadata);
    }

    @Override
    public BlobType getType() {
        return this.type;
    }

    public void setType(BlobType type) {
        this.type = type;
    }

    @Override
    public AccessTier getTier() {
        return this.tier;
    }

    @Override
    public void setTier(AccessTier tier) {
        this.tier = Preconditions.checkNotNull(tier);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(BlobProperties o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public LeaseStatus getLeaseStatus() {
        return this.leaseStatus;
    }

    @Override
    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableBlobPropertiesImpl other = (MutableBlobPropertiesImpl)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return String.format("[name=%s, container=%s, url=%s, contentMetadata=%s, eTag=%s, lastModified=%s, leaseStatus=%s, metadata=%s, type=%s]", new Object[]{this.name, this.container, this.url, this.contentMetadata, this.eTag, this.lastModified, this.leaseStatus, this.metadata, this.type});
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata contentMetadata) {
        this.contentMetadata = contentMetadata;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(String container) {
        this.container = container;
    }
}

