/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.jclouds.Fallback;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpUtils;

public final class BlobStoreFallbacks {
    private BlobStoreFallbacks() {
    }

    public static final class NullOnKeyAlreadyExists
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull(t, "throwable") instanceof KeyAlreadyExistsException) {
                return null;
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class NullOnKeyNotFound
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull(t, "throwable") instanceof KeyNotFoundException) {
                return null;
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class NullOnContainerNotFound
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull(t, "throwable") instanceof ContainerNotFoundException) {
                return null;
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class FalseOnKeyNotFound
    implements Fallback<Boolean> {
        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull(t, "throwable") instanceof KeyNotFoundException) {
                return false;
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class FalseOnContainerNotFound
    implements Fallback<Boolean> {
        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Preconditions.checkNotNull(t, "throwable") instanceof ContainerNotFoundException) {
                return false;
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class ThrowKeyNotFoundOn404
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            if (HttpUtils.contains404(Preconditions.checkNotNull(t, "throwable"))) {
                throw new KeyNotFoundException(t);
            }
            throw Throwables.propagate(t);
        }
    }

    public static final class ThrowContainerNotFoundOn404
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable t) throws Exception {
            if (HttpUtils.contains404(Preconditions.checkNotNull(t, "throwable"))) {
                throw new ContainerNotFoundException(t);
            }
            throw Throwables.propagate(t);
        }
    }
}

