/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.util.Maps2;

@Singleton
public class BindMapToHeadersWithPrefix
implements Binder {
    private final Function<String, String> fn;

    @Inject
    public BindMapToHeadersWithPrefix(final @Named(value="jclouds.blobstore.metaprefix") String metadataPrefix) {
        Preconditions.checkNotNull(metadataPrefix, "jclouds.blobstore.metaprefix");
        this.fn = new Function<String, String>(){

            @Override
            public String apply(String arg0) {
                String inLowercase = arg0.toLowerCase();
                return inLowercase.startsWith(metadataPrefix) ? inLowercase : metadataPrefix + inLowercase;
            }

            public String toString() {
                return "prefix: " + metadataPrefix;
            }
        };
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "this binder is only valid for Maps!");
        Preconditions.checkNotNull(request, "request");
        Map userMetadata = Maps2.transformKeys((Map)input, this.fn);
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(Multimaps.forMap(userMetadata))).build();
    }
}

