/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import java.net.URI;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseSystemAndUserMetadataFromHeaders
implements Function<HttpResponse, MutableBlobMetadata>,
InvocationContext<ParseSystemAndUserMetadataFromHeaders> {
    private final String metadataPrefix;
    private final DateService dateParser;
    private final Provider<MutableBlobMetadata> metadataFactory;
    private String name;
    private URI endpoint;

    @Inject
    public ParseSystemAndUserMetadataFromHeaders(Provider<MutableBlobMetadata> metadataFactory, DateService dateParser, @Named(value="jclouds.blobstore.metaprefix") String metadataPrefix) {
        this.metadataFactory = Preconditions.checkNotNull(metadataFactory, "metadataFactory");
        this.dateParser = Preconditions.checkNotNull(dateParser, "dateParser");
        this.metadataPrefix = Preconditions.checkNotNull(metadataPrefix, "metadataPrefix").toLowerCase();
    }

    @Override
    public MutableBlobMetadata apply(HttpResponse from) {
        Preconditions.checkNotNull(from, "request");
        Preconditions.checkState(this.name != null, "name must be initialized by now");
        MutableBlobMetadata to = this.metadataFactory.get();
        to.setName(this.name);
        to.setUri(this.endpoint);
        if (from.getPayload() != null) {
            HttpUtils.copy(from.getPayload().getContentMetadata(), to.getContentMetadata());
        }
        this.addETagTo(from, to);
        this.parseLastModifiedOrThrowException(from, to);
        this.addUserMetadataTo(from, to);
        return to;
    }

    @VisibleForTesting
    void addUserMetadataTo(HttpResponse from, MutableBlobMetadata metadata) {
        for (Map.Entry<String, String> header : from.getHeaders().entries()) {
            if (header.getKey() == null || !header.getKey().toLowerCase().startsWith(this.metadataPrefix)) continue;
            metadata.getUserMetadata().put(header.getKey().substring(this.metadataPrefix.length()).toLowerCase(), header.getValue());
        }
    }

    @VisibleForTesting
    void parseLastModifiedOrThrowException(HttpResponse from, MutableBlobMetadata metadata) throws HttpException {
        String lastModified = from.getFirstHeaderOrNull("Last-Modified");
        if (lastModified == null && (lastModified = from.getFirstHeaderOrNull("Last-modified")) == null) {
            throw new HttpException("Last-Modified header not present in response: " + from);
        }
        if (lastModified.startsWith("20")) {
            metadata.setLastModified(this.dateParser.iso8601DateParse(lastModified.replace("+0000", "Z")));
        } else {
            metadata.setLastModified(this.dateParser.rfc822DateParse(lastModified));
        }
        if (metadata.getLastModified() == null) {
            throw new HttpException("could not parse: Last-Modified: " + lastModified);
        }
    }

    protected void addETagTo(HttpResponse from, MutableBlobMetadata metadata) {
        String eTag = from.getFirstHeaderOrNull("ETag");
        if (metadata.getETag() == null && eTag != null) {
            metadata.setETag(eTag);
        }
    }

    @Override
    public ParseSystemAndUserMetadataFromHeaders setContext(HttpRequest request) {
        this.endpoint = request.getEndpoint();
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "note this handler requires a GeneratedHttpRequest");
        return this.setName(BlobStoreUtils.getNameFor((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)));
    }

    public ParseSystemAndUserMetadataFromHeaders setName(String name) {
        this.name = Preconditions.checkNotNull(name, "name");
        return this;
    }
}

