/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.internal.LocationImpl;

public final class LocationBuilder {
    private LocationScope scope;
    private String id;
    private String description;
    private Location parent;
    private Set<String> iso3166Codes = ImmutableSet.of();
    private Map<String, Object> metadata = ImmutableMap.of();

    public LocationBuilder scope(LocationScope scope) {
        this.scope = scope;
        return this;
    }

    public LocationBuilder id(String id) {
        this.id = id;
        return this;
    }

    public LocationBuilder description(String description) {
        this.description = description;
        return this;
    }

    public LocationBuilder parent(Location parent) {
        this.parent = parent;
        return this;
    }

    public LocationBuilder iso3166Codes(Iterable<String> iso3166Codes) {
        this.iso3166Codes = ImmutableSet.copyOf(Preconditions.checkNotNull(iso3166Codes, "iso3166Codes"));
        return this;
    }

    public LocationBuilder metadata(Map<String, Object> metadata) {
        this.metadata = ImmutableMap.copyOf(Preconditions.checkNotNull(metadata, "metadata"));
        return this;
    }

    public Location build() {
        return new LocationImpl(this.scope, this.id, this.description, this.parent, this.iso3166Codes, this.metadata);
    }
}

