/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore.functions;

import java.util.TreeSet;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.googlecloudstorage.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.googlecloudstorage.domain.GoogleCloudStorageObject;
import org.jclouds.googlecloudstorage.domain.ListPageWithPrefixes;

public class ObjectListToStorageMetadata
implements Function<ListPageWithPrefixes<GoogleCloudStorageObject>, PageSet<? extends StorageMetadata>> {
    private final ObjectToBlobMetadata object2blobMd;

    @Inject
    public ObjectListToStorageMetadata(ObjectToBlobMetadata object2blobMd) {
        this.object2blobMd = object2blobMd;
    }

    @Override
    public PageSet<? extends StorageMetadata> apply(ListPageWithPrefixes<GoogleCloudStorageObject> from) {
        if (from == null) {
            from = ListPageWithPrefixes.create(null, null, null);
        }
        TreeSet<MutableBlobMetadata> results = Sets.newTreeSet(Iterables.transform(from, this.object2blobMd));
        for (String prefix : from.prefixes()) {
            MutableStorageMetadataImpl metadata = new MutableStorageMetadataImpl();
            metadata.setType(StorageType.RELATIVE_PATH);
            metadata.setName(prefix);
            results.add((MutableBlobMetadata)((Object)metadata));
        }
        return new PageSetImpl<MutableBlobMetadata>(results, from.nextPageToken());
    }
}

