/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.handlers;

import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.core.Response;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;

@Singleton
public final class GoogleCloudStorageClientErrorRetryHandler
implements HttpRetryHandler {
    private final BackoffLimitedRetryHandler backoffHandler;

    @Inject
    protected GoogleCloudStorageClientErrorRetryHandler(BackoffLimitedRetryHandler backoffHandler) {
        this.backoffHandler = backoffHandler;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (response.getStatusCode() == Response.Status.TOO_MANY_REQUESTS.getStatusCode()) {
            return this.backoffHandler.shouldRetryRequest(command, response);
        }
        return false;
    }
}

