/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.LinkedHashMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.Uris;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.javax.annotation.Nullable;

public class HttpRequest
extends HttpMessage {
    public static final Set<String> NON_PAYLOAD_METHODS = ImmutableSet.of("OPTIONS", "GET", "HEAD", "DELETE", "TRACE", "CONNECT", new String[0]);
    private final String method;
    private final URI endpoint;
    private final List<HttpRequestFilter> filters;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHttpRequest(this);
    }

    protected HttpRequest(String method, URI endpoint, Multimap<String, String> headers, @Nullable Payload payload, Iterable<HttpRequestFilter> filters) {
        super(headers, payload);
        this.method = Preconditions.checkNotNull(method, "method");
        this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
        Preconditions.checkArgument(endpoint.getHost() != null, "endpoint.getHost() is null for %s", (Object)endpoint);
        this.filters = ImmutableList.copyOf(Preconditions.checkNotNull(filters, "filters"));
    }

    public String getRequestLine() {
        return String.format("%s %s HTTP/1.1", this.getMethod(), this.getEndpoint().toASCIIString());
    }

    public String getMethod() {
        return this.method;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public List<HttpRequestFilter> getFilters() {
        return this.filters;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.method, this.endpoint, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpRequest)) {
            return false;
        }
        HttpRequest that = (HttpRequest)HttpRequest.class.cast(obj);
        return super.equals(that) && Objects.equal(this.method, that.method) && Objects.equal(this.endpoint, that.endpoint);
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("method", this.method).add("endpoint", this.endpoint).add("headers", this.headers).add("payload", this.payload);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends HttpMessage.Builder<T> {
        protected String method;
        protected URI endpoint;
        protected ImmutableList.Builder<HttpRequestFilter> filters = ImmutableList.builder();

        public T method(String method) {
            this.method = Preconditions.checkNotNull(method, "method");
            return (T)((Builder)this.self());
        }

        public T endpoint(URI endpoint) {
            this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
            return (T)((Builder)this.self());
        }

        public T endpoint(String endpoint) {
            return this.endpoint(URI.create(Preconditions.checkNotNull(endpoint, "endpoint")));
        }

        public T addQueryParam(String name, Iterable<String> values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).addQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T addQueryParam(String name, String ... values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).addQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T addQueryParams(Multimap<String, String> parameters) {
            this.endpoint = Uris.uriBuilder(this.endpoint).addQuery(parameters).build();
            return (T)((Builder)this.self());
        }

        public T replaceQueryParam(String name, Iterable<String> values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).replaceQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T replaceQueryParam(String name, String ... values) {
            this.endpoint = Uris.uriBuilder(this.endpoint).replaceQuery(name, values).build();
            return (T)((Builder)this.self());
        }

        public T replaceQueryParams(Map<String, String> parameters) {
            return this.replaceQueryParams(Multimaps.forMap(parameters));
        }

        public T replaceQueryParams(Multimap<String, String> parameters) {
            this.endpoint = Uris.uriBuilder(this.endpoint).replaceQuery(parameters).build();
            return (T)((Builder)this.self());
        }

        public T replacePath(String path) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            Preconditions.checkNotNull(path, "path");
            this.endpoint = Uris.uriBuilder(this.endpoint).path(path).build();
            return (T)((Builder)this.self());
        }

        public T addFormParam(String name, String ... values) {
            return this.addFormParams(ImmutableMultimap.builder().putAll(Preconditions.checkNotNull(name, "name"), Preconditions.checkNotNull(values, "values of %s", (Object)name)).build());
        }

        public T addFormParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            LinkedHashMultimap<String, String> map = this.payload != null ? Queries.queryParser().apply(this.payload.getRawContent().toString()) : LinkedHashMultimap.create();
            map.putAll(parameters);
            this.payload = Payloads.newUrlEncodedFormPayload(map);
            return (T)((Builder)this.self());
        }

        public T replaceFormParam(String name, String ... values) {
            return this.replaceFormParams(ImmutableMultimap.builder().putAll(Preconditions.checkNotNull(name, "name"), Preconditions.checkNotNull(values, "values of %s", (Object)name)).build());
        }

        public T replaceFormParams(Multimap<String, String> parameters) {
            Preconditions.checkNotNull(this.endpoint, "endpoint");
            LinkedHashMultimap<String, String> map = this.payload != null ? Queries.queryParser().apply(this.payload.getRawContent().toString()) : LinkedHashMultimap.create();
            for (Map.Entry<String, Collection<String>> entry : parameters.asMap().entrySet()) {
                map.replaceValues(entry.getKey(), (Iterable<String>)entry.getValue());
            }
            this.payload = Payloads.newUrlEncodedFormPayload(map);
            return (T)((Builder)this.self());
        }

        public T filters(Iterable<HttpRequestFilter> filters) {
            this.filters = ImmutableList.builder();
            this.filters.addAll((Iterable)Preconditions.checkNotNull(filters, "filters"));
            return (T)((Builder)this.self());
        }

        public T filter(HttpRequestFilter filter) {
            this.filters.add((Object)Preconditions.checkNotNull(filter, "filter"));
            return (T)((Builder)this.self());
        }

        @Override
        public HttpRequest build() {
            return new HttpRequest(this.method, this.endpoint, this.headers.build(), this.payload, this.filters.build());
        }

        public T fromHttpRequest(HttpRequest in) {
            return ((Builder)((Builder)((Builder)super.fromHttpMessage(in)).method(in.getMethod())).endpoint(in.getEndpoint())).filters(in.getFilters());
        }
    }
}

