/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Enums;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.catalog.AutoValue_ServiceEndpoint;

public abstract class ServiceEndpoint {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String regionId();

    public abstract URI url();

    public abstract Interface iface();

    public abstract String type();

    @Nullable
    public abstract String version();

    ServiceEndpoint() {
    }

    public static Builder builder() {
        return new AutoValue_ServiceEndpoint.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder regionId(String var1);

        public abstract Builder url(URI var1);

        public abstract Builder iface(Interface var1);

        public abstract Builder type(String var1);

        public abstract Builder version(String var1);

        public Builder iface(String iface) {
            return this.iface(Interface.fromValue(iface));
        }

        public abstract ServiceEndpoint build();
    }

    public static enum Interface {
        PUBLIC,
        ADMIN,
        INTERNAL,
        UNRECOGNIZED;


        public static Interface fromValue(String iface) {
            return Enums.getIfPresent(Interface.class, iface.toUpperCase()).or(UNRECOGNIZED);
        }
    }
}

