/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PUT;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.options.CreateTenantOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateTenantOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Consumes(value={"application/json"})
@Extension(of="identity", namespace="http://docs.openstack.org/identity/api/ext/OS-KSADM/v1.0", name="OpenStack Keystone Admin", alias="OS-KSADM")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/tenants")
@Beta
public interface TenantAdminApi {
    @Named(value="tenant:create")
    @POST
    @SelectJson(value={"tenant"})
    @Produces(value={"application/json"})
    @Nullable
    public Tenant create(@PayloadParam(value="name") String var1);

    @Named(value="tenant:create")
    @POST
    @SelectJson(value={"tenant"})
    @MapBinder(value=CreateTenantOptions.class)
    @Nullable
    public Tenant create(@PayloadParam(value="name") String var1, CreateTenantOptions var2);

    @Named(value="tenant:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="tenant:updateTenant")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"tenant"})
    @MapBinder(value=UpdateTenantOptions.class)
    @Nullable
    public Tenant update(@PathParam(value="id") String var1, UpdateTenantOptions var2);

    @Named(value="tenant:addRoleOnTenant")
    @PUT
    @Path(value="/{id}/users/{userId}/roles/OS-KSADM/{roleId}")
    public void addRoleOnTenant(@PathParam(value="id") String var1, @PathParam(value="userId") String var2, @PathParam(value="roleId") String var3);

    @Named(value="tenant:deleteRoleOnTenant")
    @DELETE
    @Path(value="/{id}/users/{userId}/roles/OS-KSADM/{roleId}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteRoleOnTenant(@PathParam(value="id") String var1, @PathParam(value="userId") String var2, @PathParam(value="roleId") String var3);
}

