/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1;

import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Suppliers;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.jclouds.openstack.swift.v1.features.AccountApi;

public class TemporaryUrlSigner {
    private final Supplier<String> keySupplier;

    public static TemporaryUrlSigner checkApiEvery(AccountApi api, long seconds) {
        Supplier<String> keySupplier = Suppliers.memoizeWithExpiration(new TemporaryUrlKeyFromAccount(api), seconds, TimeUnit.SECONDS);
        return new TemporaryUrlSigner(keySupplier);
    }

    TemporaryUrlSigner(Supplier<String> keySupplier) {
        this.keySupplier = keySupplier;
    }

    public String sign(String method, String path, long expirationTimestampSeconds) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(path, "path");
        Preconditions.checkArgument(expirationTimestampSeconds > 0L, "expirationTimestamp must be a unix epoch timestamp");
        String hmacBody = String.format("%s\n%s\n%s", method, expirationTimestampSeconds, path);
        return BaseEncoding.base16().lowerCase().encode(this.hmacSHA1(hmacBody));
    }

    byte[] hmacSHA1(String data) {
        try {
            String key = this.keySupplier.get();
            Preconditions.checkState(key != null, "%s returned a null temporaryUrlKey!", this.keySupplier);
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key.getBytes(Charsets.UTF_8), "HmacSHA1"));
            return mac.doFinal(data.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    static class TemporaryUrlKeyFromAccount
    implements Supplier<String> {
        private final AccountApi api;

        private TemporaryUrlKeyFromAccount(AccountApi api) {
            this.api = Preconditions.checkNotNull(api, "accountApi");
        }

        @Override
        public String get() {
            return this.api.get().getTemporaryUrlKey().orNull();
        }

        public String toString() {
            return String.format("get().getTemporaryUrlKey() using %s", this.api);
        }
    }
}

