/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.domain;

import java.beans.ConstructorProperties;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;

public class Container
implements Comparable<Container> {
    private final String name;
    private final Long objectCount;
    private final Long bytesUsed;
    private final Optional<Boolean> anybodyRead;
    private final Map<String, String> metadata;
    private final Multimap<String, String> headers;

    @ConstructorProperties(value={"name", "count", "bytes", "anybodyRead", "metadata", "headers"})
    protected Container(String name, Long objectCount, Long bytesUsed, Optional<Boolean> anybodyRead, Map<String, String> metadata, Multimap<String, String> headers) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.objectCount = objectCount;
        this.bytesUsed = bytesUsed;
        this.anybodyRead = anybodyRead == null ? Optional.absent() : anybodyRead;
        this.metadata = metadata == null ? ImmutableMap.of() : metadata;
        this.headers = headers == null ? ImmutableMultimap.of() : headers;
    }

    public String getName() {
        return this.name;
    }

    public Long getObjectCount() {
        return this.objectCount;
    }

    public Long getBytesUsed() {
        return this.bytesUsed;
    }

    public Optional<Boolean> getAnybodyRead() {
        return this.anybodyRead;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Container) {
            Container that = (Container)Container.class.cast(object);
            return Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getObjectCount(), that.getObjectCount()) && Objects.equal(this.getBytesUsed(), that.getBytesUsed()) && Objects.equal(this.getMetadata(), that.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.getObjectCount(), this.getBytesUsed(), this.getAnybodyRead(), this.getMetadata());
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.getName()).add("objectCount", this.getObjectCount()).add("bytesUsed", this.getBytesUsed()).add("anybodyRead", this.getAnybodyRead().orNull()).add("metadata", this.getMetadata());
    }

    @Override
    public int compareTo(Container that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getName().compareTo(that.getName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Container.builder().fromContainer(this);
    }

    public static class Builder {
        protected String name;
        protected Long objectCount;
        protected Long bytesUsed;
        protected Optional<Boolean> anybodyRead = Optional.absent();
        protected Map<String, String> metadata = ImmutableMap.of();
        protected Multimap<String, String> headers = ImmutableMultimap.of();

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public Builder bytesUsed(Long bytesUsed) {
            this.bytesUsed = bytesUsed;
            return this;
        }

        public Builder anybodyRead(Boolean anybodyRead) {
            this.anybodyRead = Optional.fromNullable(anybodyRead);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : Preconditions.checkNotNull(metadata, "metadata").entrySet()) {
                builder.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            this.metadata = builder.build();
            return this;
        }

        public Builder headers(Multimap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Container build() {
            return new Container(this.name, this.objectCount, this.bytesUsed, this.anybodyRead, this.metadata, this.headers);
        }

        public Builder fromContainer(Container from) {
            return this.name(from.getName()).objectCount(from.getObjectCount()).bytesUsed(from.getBytesUsed()).anybodyRead(from.getAnybodyRead().orNull()).metadata(from.getMetadata()).headers(from.getHeaders());
        }
    }
}

