/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.net.InternetDomainName;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.rest.Binder;

@Singleton
public class BindAsHostPrefix
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkNotNull(payload, "hostprefix");
        Preconditions.checkArgument(InternetDomainName.isValid(request.getEndpoint().getHost()), "this is only valid for hostnames: " + request);
        InternetDomainName name = InternetDomainName.from(request.getEndpoint().getHost()).child(payload.toString());
        URI newEndpoint = Uris.uriBuilder(request.getEndpoint()).host(name.toString()).build();
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(newEndpoint)).replacePath(request.getEndpoint().getRawPath())).build();
    }
}

