/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.domain.S3Object;

@Singleton
public class BlobToObject
implements Function<Blob, S3Object> {
    private final BlobToObjectMetadata blob2ObjectMd;
    private final S3Object.Factory objectProvider;

    @Inject
    BlobToObject(BlobToObjectMetadata blob2ObjectMd, S3Object.Factory objectProvider) {
        this.blob2ObjectMd = blob2ObjectMd;
        this.objectProvider = objectProvider;
    }

    @Override
    public S3Object apply(Blob from) {
        if (from == null) {
            return null;
        }
        S3Object object = this.objectProvider.create(this.blob2ObjectMd.apply(from.getMetadata()));
        object.setPayload(Preconditions.checkNotNull(from.getPayload(), "payload: " + from));
        object.setAllHeaders(from.getAllHeaders());
        return object;
    }
}

