/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarAuthorizationProvider
implements AuthorizationProvider {
    private static final Logger log = LoggerFactory.getLogger(PulsarAuthorizationProvider.class);
    public ServiceConfiguration conf;
    protected PulsarResources pulsarResources;

    public PulsarAuthorizationProvider() {
    }

    public PulsarAuthorizationProvider(ServiceConfiguration conf, PulsarResources resources) throws IOException {
        this.initialize(conf, resources);
    }

    @Override
    public void initialize(ServiceConfiguration conf, PulsarResources pulsarResources) throws IOException {
        Objects.requireNonNull(conf, "ServiceConfiguration can't be null");
        Objects.requireNonNull(pulsarResources, "PulsarResources can't be null");
        this.conf = conf;
        this.pulsarResources = pulsarResources;
    }

    @Override
    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.checkAuthorization(topicName, role, AuthAction.produce);
    }

    @Override
    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        return this.pulsarResources.getNamespaceResources().getPoliciesAsync(topicName.getNamespaceObject()).thenCompose(policies -> {
            if (!policies.isPresent()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies node couldn't be found for topic : {}", (Object)topicName);
                }
            } else if (StringUtils.isNotBlank((CharSequence)subscription)) {
                Set roles = (Set)((Policies)policies.get()).auth_policies.getSubscriptionAuthentication().get(subscription);
                if (roles != null && !roles.isEmpty() && !roles.contains(role)) {
                    log.warn("[{}] is not authorized to subscribe on {}-{}", new Object[]{role, topicName, subscription});
                    return CompletableFuture.completedFuture(false);
                }
                if (((Policies)policies.get()).subscription_auth_mode != null) {
                    switch (((Policies)policies.get()).subscription_auth_mode) {
                        case Prefix: {
                            if (subscription.startsWith(role)) break;
                            PulsarServerException ex = new PulsarServerException(String.format("Failed to create consumer - The subscription name needs to be prefixed by the authentication role, like %s-xxxx for topic: %s", role, topicName));
                            return FutureUtil.failedFuture((Throwable)ex);
                        }
                    }
                }
            }
            return this.checkAuthorization(topicName, role, AuthAction.consume);
        });
    }

    @Override
    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.canProduceAsync(topicName, role, authenticationData).thenCompose(canProduce -> {
            if (canProduce.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.canConsumeAsync(topicName, role, authenticationData, null);
        });
    }

    @Override
    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.functions);
    }

    @Override
    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.sources);
    }

    @Override
    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.sinks);
    }

    private CompletableFuture<Boolean> allowConsumeOrProduceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.consume).thenCompose(canConsumer -> {
            if (canConsumer.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.produce);
        });
    }

    private CompletableFuture<Boolean> allowTheSpecifiedActionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData, AuthAction authAction) {
        return this.pulsarResources.getNamespaceResources().getPoliciesAsync(namespaceName).thenApply(policies -> {
            if (!policies.isPresent()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies node couldn't be found for namespace : {}", (Object)namespaceName);
                }
            } else {
                Map namespaceRoles = ((Policies)policies.get()).auth_policies.getNamespaceAuthentication();
                Set namespaceActions = (Set)namespaceRoles.get(role);
                if (namespaceActions != null && namespaceActions.contains(authAction)) {
                    return true;
                }
                if (this.conf.isAuthorizationAllowWildcardsMatching() && this.checkWildcardPermission(role, authAction, namespaceRoles)) {
                    return true;
                }
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Void> grantPermissionAsync(TopicName topicName, Set<AuthAction> actions, String role, String authDataJson) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            String topicUri = topicName.toString();
            return this.pulsarResources.getNamespaceResources().setPoliciesAsync(topicName.getNamespaceObject(), policies -> {
                policies.auth_policies.getTopicAuthentication().computeIfAbsent(topicUri, __ -> new HashMap()).put(role, actions);
                return policies;
            }).whenComplete((__, ex) -> {
                if (ex != null) {
                    log.error("Failed to set permissions for role {} on topic {}", new Object[]{role, topicName, ex});
                } else {
                    log.info("Successfully granted access for role {}: {} - topic {}", new Object[]{role, actions, topicUri});
                }
            });
        });
    }

    @Override
    public CompletableFuture<Void> revokePermissionAsync(TopicName topicName, String role) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return this.pulsarResources.getNamespaceResources().setPoliciesAsync(topicName.getNamespaceObject(), policies -> {
                policies.auth_policies.getTopicAuthentication().computeIfPresent(topicName.toString(), (topicNameUri, roles) -> {
                    roles.remove(role);
                    if (roles.isEmpty()) {
                        return null;
                    }
                    return roles;
                });
                return policies;
            }).whenComplete((__, ex) -> {
                if (ex != null) {
                    log.error("Failed to revoke permissions for role {} on topic {}", new Object[]{role, topicName, ex});
                } else {
                    log.info("Successfully revoke permissions for role {} on topic {}", (Object)role, (Object)topicName);
                }
            });
        });
    }

    @Override
    public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespaceName, Set<AuthAction> actions, String role, String authDataJson) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return this.pulsarResources.getNamespaceResources().setPoliciesAsync(namespaceName, policies -> {
                policies.auth_policies.getNamespaceAuthentication().put(role, actions);
                return policies;
            }).whenComplete((__, ex) -> {
                if (ex != null) {
                    log.error("Failed to set permissions for role {} namespace {}", new Object[]{role, namespaceName, ex});
                } else {
                    log.info("Successfully granted access for role {}: {} - namespace {}", new Object[]{role, actions, namespaceName});
                }
            });
        });
    }

    @Override
    public CompletableFuture<Void> revokePermissionAsync(NamespaceName namespaceName, String role) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return this.pulsarResources.getNamespaceResources().setPoliciesAsync(namespaceName, policies -> {
                policies.auth_policies.getNamespaceAuthentication().remove(role);
                return policies;
            }).whenComplete((__, ex) -> {
                if (ex != null) {
                    log.error("Failed to revoke permissions for role {} namespace {}", new Object[]{role, namespaceName, ex});
                } else {
                    log.info("Successfully revoke permissions for role {} namespace {}", (Object)role, (Object)namespaceName);
                }
            });
        });
    }

    @Override
    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
        return this.updateSubscriptionPermissionAsync(namespace, subscriptionName, roles, false);
    }

    @Override
    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
        return this.updateSubscriptionPermissionAsync(namespace, subscriptionName, Collections.singleton(role), true);
    }

    private CompletableFuture<Void> updateSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, boolean remove) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return this.pulsarResources.getNamespaceResources().setPoliciesAsync(namespace, policies -> {
                if (!remove) {
                    policies.auth_policies.getSubscriptionAuthentication().put(subscriptionName, roles);
                    return policies;
                }
                Set subscriptionAuth = (Set)policies.auth_policies.getSubscriptionAuthentication().get(subscriptionName);
                if (subscriptionAuth != null) {
                    subscriptionAuth.removeAll(roles);
                    if (!subscriptionAuth.isEmpty()) return policies;
                    policies.auth_policies.getSubscriptionAuthentication().remove(subscriptionName);
                    return policies;
                }
                log.info("[{}] Couldn't find role {} while revoking for sub = {}", new Object[]{namespace, roles, subscriptionName});
                throw new IllegalArgumentException("couldn't find subscription");
            }).whenComplete((__, throwable) -> {
                if (throwable != null) {
                    log.error("[{}] Failed to set permissions for role {} on namespace {}", new Object[]{subscriptionName, roles, namespace, throwable});
                } else {
                    log.info("[{}] Successfully granted access for role {} for sub = {}", new Object[]{namespace, roles, subscriptionName});
                }
            });
        });
    }

    private CompletableFuture<Boolean> checkAuthorization(TopicName topicName, String role, AuthAction action) {
        return this.checkPermission(topicName, role, action).thenCompose(permission -> permission != false ? this.checkCluster(topicName) : CompletableFuture.completedFuture(false));
    }

    private CompletableFuture<Boolean> checkCluster(TopicName topicName) {
        if (topicName.isGlobal() || this.conf.getClusterName().equals(topicName.getCluster())) {
            return CompletableFuture.completedFuture(true);
        }
        if (log.isDebugEnabled()) {
            log.debug("Topic [{}] does not belong to local cluster [{}]", (Object)topicName.toString(), (Object)this.conf.getClusterName());
        }
        return this.pulsarResources.getClusterResources().listAsync().thenApply(clusters -> clusters.contains(topicName.getCluster()));
    }

    public CompletableFuture<Boolean> checkPermission(TopicName topicName, String role, AuthAction action) {
        return this.pulsarResources.getNamespaceResources().getPoliciesAsync(topicName.getNamespaceObject()).thenApply(policies -> {
            if (!policies.isPresent()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies node couldn't be found for topic : {}", (Object)topicName);
                }
            } else {
                Set topicActions;
                Map namespaceRoles = ((Policies)policies.get()).auth_policies.getNamespaceAuthentication();
                Set namespaceActions = (Set)namespaceRoles.get(role);
                if (namespaceActions != null && namespaceActions.contains(action)) {
                    return true;
                }
                Map topicRoles = (Map)((Policies)policies.get()).auth_policies.getTopicAuthentication().get(topicName.toString());
                if (topicRoles != null && role != null && (topicActions = (Set)topicRoles.get(role)) != null && topicActions.contains(action)) {
                    return true;
                }
                if (this.conf.isAuthorizationAllowWildcardsMatching()) {
                    if (this.checkWildcardPermission(role, action, namespaceRoles)) {
                        return true;
                    }
                    if (topicRoles != null && this.checkWildcardPermission(role, action, topicRoles)) {
                        return true;
                    }
                }
                if (topicName.isPartitioned() && (topicRoles = (Map)((Policies)policies.get()).auth_policies.getTopicAuthentication().get(topicName.getPartitionedTopicName())) != null && (topicActions = (Set)topicRoles.get(role)) != null && topicActions.contains(action)) {
                    return true;
                }
            }
            return false;
        });
    }

    private boolean checkWildcardPermission(String checkedRole, AuthAction checkedAction, Map<String, Set<AuthAction>> permissionMap) {
        for (Map.Entry<String, Set<AuthAction>> permissionData : permissionMap.entrySet()) {
            String permittedRole = permissionData.getKey();
            Set<AuthAction> permittedActions = permissionData.getValue();
            if (checkedRole == null) continue;
            if (permittedRole.charAt(permittedRole.length() - 1) == '*' && checkedRole.startsWith(permittedRole.substring(0, permittedRole.length() - 1)) && permittedActions.contains(checkedAction)) {
                return true;
            }
            if (permittedRole.charAt(0) != '*' || !checkedRole.endsWith(permittedRole.substring(1)) || !permittedActions.contains(checkedAction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    private CompletableFuture<Boolean> getPoliciesReadOnlyAsync() {
        return this.pulsarResources.getNamespaceResources().getPoliciesReadOnlyAsync();
    }

    @Override
    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.validateTenantAdminAccess(tenantName, role, authData);
    }

    @Override
    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        if (log.isDebugEnabled()) {
            log.debug("Check allowNamespaceOperationAsync [{}] on [{}].", (Object)operation.name(), (Object)namespaceName);
        }
        return this.validateTenantAdminAccess(namespaceName.getTenant(), role, authData).thenCompose(isSuperUserOrAdmin -> {
            if (log.isDebugEnabled()) {
                log.debug("Verify if role {} is allowed to {} to namespace {}: isSuperUserOrAdmin={}", new Object[]{role, operation, namespaceName, isSuperUserOrAdmin});
            }
            if (isSuperUserOrAdmin.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            switch (operation) {
                case PACKAGES: {
                    return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authData, AuthAction.packages);
                }
                case GET_TOPIC: 
                case GET_TOPICS: 
                case GET_BUNDLE: {
                    return this.allowConsumeOrProduceOpsAsync(namespaceName, role, authData);
                }
                case UNSUBSCRIBE: 
                case TRIM_TOPIC: 
                case CLEAR_BACKLOG: {
                    return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authData, AuthAction.consume);
                }
                case CREATE_TOPIC: 
                case DELETE_TOPIC: 
                case ADD_BUNDLE: 
                case DELETE_BUNDLE: 
                case GRANT_PERMISSION: 
                case GET_PERMISSION: 
                case REVOKE_PERMISSION: {
                    return CompletableFuture.completedFuture(false);
                }
            }
            return FutureUtil.failedFuture((Throwable)new IllegalStateException("NamespaceOperation [" + operation.name() + "] is not supported."));
        });
    }

    @Override
    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return this.validateTenantAdminAccess(namespaceName.getTenant(), role, authData);
    }

    @Override
    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, String role, TopicOperation operation, AuthenticationDataSource authData) {
        if (log.isDebugEnabled()) {
            log.debug("Check allowTopicOperationAsync [{}] on [{}].", (Object)operation.name(), (Object)topicName);
        }
        return this.validateTenantAdminAccess(topicName.getTenant(), role, authData).thenCompose(isSuperUserOrAdmin -> {
            if (log.isDebugEnabled()) {
                log.debug("Verify if role {} is allowed to {} to topic {}: isSuperUserOrAdmin={}", new Object[]{role, operation, topicName, isSuperUserOrAdmin});
            }
            if (isSuperUserOrAdmin.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            switch (operation) {
                case LOOKUP: 
                case GET_STATS: 
                case GET_METADATA: {
                    return this.canLookupAsync(topicName, role, authData);
                }
                case PRODUCE: {
                    return this.canProduceAsync(topicName, role, authData);
                }
                case GET_SUBSCRIPTIONS: 
                case CONSUME: 
                case SUBSCRIBE: 
                case UNSUBSCRIBE: 
                case SKIP: 
                case EXPIRE_MESSAGES: 
                case PEEK_MESSAGES: 
                case RESET_CURSOR: 
                case GET_BACKLOG_SIZE: 
                case SET_REPLICATED_SUBSCRIPTION_STATUS: 
                case GET_REPLICATED_SUBSCRIPTION_STATUS: {
                    return this.canConsumeAsync(topicName, role, authData, authData.getSubscription());
                }
                case TERMINATE: 
                case COMPACT: 
                case OFFLOAD: 
                case UNLOAD: 
                case TRIM_TOPIC: 
                case DELETE_METADATA: 
                case UPDATE_METADATA: 
                case ADD_BUNDLE_RANGE: 
                case GET_BUNDLE_RANGE: 
                case DELETE_BUNDLE_RANGE: {
                    return CompletableFuture.completedFuture(false);
                }
            }
            return FutureUtil.failedFuture((Throwable)new IllegalStateException("TopicOperation [" + operation.name() + "] is not supported."));
        });
    }

    @Override
    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, String role, PolicyName policyName, PolicyOperation policyOperation, AuthenticationDataSource authData) {
        return this.validateTenantAdminAccess(topicName.getTenant(), role, authData);
    }

    public CompletableFuture<Boolean> validateTenantAdminAccess(String tenantName, String role, AuthenticationDataSource authData) {
        return this.isSuperUser(role, authData, this.conf).thenCompose(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return ((CompletableFuture)this.pulsarResources.getTenantResources().getTenantAsync(tenantName).thenCompose(op -> {
                if (op.isPresent()) {
                    return this.isTenantAdmin(tenantName, role, (TenantInfo)op.get(), authData);
                }
                throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
            })).exceptionally(ex -> {
                Throwable cause = ex.getCause();
                if (cause instanceof MetadataStoreException.NotFoundException) {
                    log.warn("Failed to get tenant info data for non existing tenant {}", (Object)tenantName);
                    throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
                }
                log.error("Failed to get tenant {}", (Object)tenantName, (Object)cause);
                throw new RestException(cause);
            });
        });
    }

    @Override
    public CompletableFuture<Void> removePermissionsAsync(TopicName topicName) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return this.pulsarResources.getNamespaceResources().getPoliciesAsync(topicName.getNamespaceObject()).thenCompose(policies -> {
                if (!policies.isPresent() || !((Policies)policies.get()).auth_policies.getTopicAuthentication().containsKey(topicName.toString())) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.pulsarResources.getNamespaceResources().setPoliciesAsync(topicName.getNamespaceObject(), policies2 -> {
                    policies2.auth_policies.getTopicAuthentication().remove(topicName.toString());
                    return policies2;
                }).whenComplete((__, ex) -> {
                    if (ex != null) {
                        log.error("Failed to remove permissions on topic {}", (Object)topicName, ex);
                    } else {
                        log.info("Successfully remove permissions on topic {}", (Object)topicName);
                    }
                });
            });
        });
    }

    @Override
    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(TopicName topicName) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return ((CompletableFuture)this.pulsarResources.getNamespaceResources().getPoliciesAsync(topicName.getNamespaceObject()).thenApply(policies -> {
                if (!policies.isPresent()) {
                    throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
                }
                HashMap permissions = new HashMap();
                String topicUri = topicName.toString();
                AuthPolicies auth = ((Policies)policies.get()).auth_policies;
                permissions.putAll(auth.getNamespaceAuthentication());
                if (auth.getTopicAuthentication().containsKey(topicUri)) {
                    for (Map.Entry entry : ((Map)auth.getTopicAuthentication().get(topicUri)).entrySet()) {
                        String role = (String)entry.getKey();
                        Set topicPermissions = (Set)entry.getValue();
                        if (!permissions.containsKey(role)) {
                            permissions.put(role, topicPermissions);
                            continue;
                        }
                        Sets.SetView union = Sets.union((Set)((Set)permissions.get(role)), (Set)topicPermissions);
                        permissions.put(role, union);
                    }
                }
                return permissions;
            })).whenComplete((__, ex) -> {
                if (ex != null) {
                    log.error("Failed to get permissions on topic {}", (Object)topicName, ex);
                } else {
                    log.info("Successfully get permissions on topic {}", (Object)topicName);
                }
            });
        });
    }

    @Override
    public CompletableFuture<Map<String, Set<String>>> getSubscriptionPermissionsAsync(NamespaceName namespaceName) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return ((CompletableFuture)this.pulsarResources.getNamespaceResources().getPoliciesAsync(namespaceName).thenApply(policies -> {
                if (!policies.isPresent()) {
                    throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
                }
                return ((Policies)policies.get()).auth_policies.getSubscriptionAuthentication();
            })).whenComplete((__, ex) -> {
                if (ex != null) {
                    log.error("Failed to get subscription permissions on namespace {}", (Object)namespaceName, ex);
                } else {
                    log.info("Successfully get subscription permissions on namespaceName {}", (Object)namespaceName);
                }
            });
        });
    }

    @Override
    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(NamespaceName namespaceName) {
        return this.getPoliciesReadOnlyAsync().thenCompose(readonly -> {
            if (readonly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new IllegalStateException("policies are in readonly mode");
            }
            return ((CompletableFuture)this.pulsarResources.getNamespaceResources().getPoliciesAsync(namespaceName).thenApply(policies -> {
                if (!policies.isPresent()) {
                    throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
                }
                return ((Policies)policies.get()).auth_policies.getNamespaceAuthentication();
            })).whenComplete((__, ex) -> {
                if (ex != null) {
                    log.error("Failed to get permissions on namespaceName {}", (Object)namespaceName, ex);
                } else {
                    log.info("Successfully get permissions on namespaceName {}", (Object)namespaceName);
                }
            });
        });
    }
}

