/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.metadata.api.CacheGetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.zookeeper.KeeperException;

public class LocalPoliciesResources
extends BaseResources<LocalPolicies> {
    public LocalPoliciesResources(MetadataStore localStore, int operationTimeoutSec) {
        super(localStore, LocalPolicies.class, operationTimeoutSec);
    }

    public void setLocalPolicies(NamespaceName ns, Function<LocalPolicies, LocalPolicies> modifyFunction) throws MetadataStoreException {
        this.set(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()), modifyFunction);
    }

    public Optional<LocalPolicies> getLocalPolicies(NamespaceName ns) throws MetadataStoreException {
        return this.get(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()));
    }

    public CompletableFuture<Optional<LocalPolicies>> getLocalPoliciesAsync(NamespaceName ns) {
        return this.getCache().get(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()));
    }

    public void setLocalPoliciesWithCreate(NamespaceName ns, Function<Optional<LocalPolicies>, LocalPolicies> createFunction) throws MetadataStoreException {
        this.setWithCreate(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()), createFunction);
    }

    public CompletableFuture<Void> createLocalPoliciesAsync(NamespaceName ns, LocalPolicies policies) {
        return this.getCache().create(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()), (Object)policies);
    }

    public CompletableFuture<Optional<CacheGetResult<LocalPolicies>>> getLocalPoliciesWithVersion(NamespaceName ns) {
        return this.getCache().getWithStats(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()));
    }

    public CompletableFuture<Void> setLocalPoliciesWithVersion(NamespaceName ns, LocalPolicies policies, Optional<Long> version) {
        try {
            byte[] content = ObjectMapperFactory.getMapper().writer().writeValueAsBytes((Object)policies);
            return this.getStore().put(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()), content, version).thenApply(__ -> null);
        }
        catch (JsonProcessingException e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
    }

    public void deleteLocalPolicies(NamespaceName ns) throws MetadataStoreException {
        this.delete(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()));
    }

    public CompletableFuture<Void> deleteLocalPoliciesAsync(NamespaceName ns) {
        return this.deleteIfExistsAsync(LocalPoliciesResources.joinPath("/admin/local-policies", ns.toString()));
    }

    public CompletableFuture<Void> deleteLocalPoliciesTenantAsync(String tenant) {
        String localPoliciesPath = LocalPoliciesResources.joinPath("/admin/local-policies", tenant);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.deleteIfExistsAsync(localPoliciesPath).whenComplete((ignore, ex) -> {
            if (ex != null && ex.getCause().getCause() instanceof KeeperException) {
                future.complete(null);
            } else if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public static boolean isLocalPoliciesPath(String path) {
        return path.startsWith("/admin/local-policies");
    }
}

