/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pulsar.client.api.BatchReceivePolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.ReaderInterceptorUtil;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.CompletableFutureCancellationHandler;
import org.apache.pulsar.shade.client.api.v2.Consumer;
import org.apache.pulsar.shade.client.api.v2.MessageListener;
import org.apache.pulsar.shade.client.api.v2.Reader;
import org.apache.pulsar.shade.client.api.v2.ReaderListener;
import org.apache.pulsar.shade.org.apache.commons.codec.digest.DigestUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderImpl<T>
implements Reader<T> {
    private static final Logger log = LoggerFactory.getLogger(ReaderImpl.class);
    private static final BatchReceivePolicy DISABLED_BATCH_RECEIVE_POLICY = BatchReceivePolicy.builder().timeout(0, TimeUnit.MILLISECONDS).maxNumMessages(1).build();
    private final ConsumerImpl<T> consumer;

    public ReaderImpl(PulsarClientImpl client, ReaderConfigurationData<T> readerConfiguration, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> consumerFuture, Schema<T> schema) {
        String subscription;
        if (StringUtils.isNotBlank(readerConfiguration.getSubscriptionName())) {
            subscription = readerConfiguration.getSubscriptionName();
        } else {
            subscription = "reader-" + DigestUtils.sha1Hex(UUID.randomUUID().toString()).substring(0, 10);
            if (StringUtils.isNotBlank(readerConfiguration.getSubscriptionRolePrefix())) {
                subscription = readerConfiguration.getSubscriptionRolePrefix() + "-" + subscription;
            }
        }
        ConsumerConfigurationData consumerConfiguration = new ConsumerConfigurationData();
        consumerConfiguration.getTopicNames().add(readerConfiguration.getTopicName());
        consumerConfiguration.setSubscriptionName(subscription);
        consumerConfiguration.setSubscriptionType(SubscriptionType.Exclusive);
        consumerConfiguration.setSubscriptionMode(readerConfiguration.getSubscriptionMode());
        consumerConfiguration.setSubscriptionInitialPosition(readerConfiguration.getSubscriptionInitialPosition());
        consumerConfiguration.setReceiverQueueSize(readerConfiguration.getReceiverQueueSize());
        consumerConfiguration.setReadCompacted(readerConfiguration.isReadCompacted());
        consumerConfiguration.setPoolMessages(readerConfiguration.isPoolMessages());
        consumerConfiguration.setMaxPendingChunkedMessage(readerConfiguration.getMaxPendingChunkedMessage());
        consumerConfiguration.setAutoAckOldestChunkedMessageOnQueueFull(readerConfiguration.isAutoAckOldestChunkedMessageOnQueueFull());
        consumerConfiguration.setExpireTimeOfIncompleteChunkedMessageMillis(readerConfiguration.getExpireTimeOfIncompleteChunkedMessageMillis());
        consumerConfiguration.setBatchReceivePolicy(DISABLED_BATCH_RECEIVE_POLICY);
        if (readerConfiguration.getReaderName() != null) {
            consumerConfiguration.setConsumerName(readerConfiguration.getReaderName());
        }
        if (readerConfiguration.isResetIncludeHead()) {
            consumerConfiguration.setResetIncludeHead(true);
        }
        if (readerConfiguration.getReaderListener() != null) {
            final ReaderListener<T> readerListener = readerConfiguration.getReaderListener();
            consumerConfiguration.setMessageListener(new MessageListener<T>(){
                private static final long serialVersionUID = 1L;

                @Override
                public void received(Consumer<T> consumer, Message<T> msg) {
                    MessageId messageId = msg.getMessageId();
                    readerListener.received(ReaderImpl.this, msg);
                    consumer.acknowledgeCumulativeAsync(messageId).exceptionally(ex -> {
                        log.error("[{}][{}] auto acknowledge message {} cumulative fail.", new Object[]{ReaderImpl.this.getTopic(), ReaderImpl.this.getConsumer().getSubscription(), messageId, ex});
                        return null;
                    });
                }

                @Override
                public void reachedEndOfTopic(Consumer<T> consumer) {
                    readerListener.reachedEndOfTopic(ReaderImpl.this);
                }
            });
        }
        consumerConfiguration.setCryptoFailureAction(readerConfiguration.getCryptoFailureAction());
        if (readerConfiguration.getCryptoKeyReader() != null) {
            consumerConfiguration.setCryptoKeyReader(readerConfiguration.getCryptoKeyReader());
        }
        if (readerConfiguration.getMessageCrypto() != null) {
            consumerConfiguration.setMessageCrypto(readerConfiguration.getMessageCrypto());
        }
        if (readerConfiguration.getKeyHashRanges() != null) {
            consumerConfiguration.setKeySharedPolicy(KeySharedPolicy.stickyHashRange().ranges(readerConfiguration.getKeyHashRanges()));
        }
        ConsumerInterceptors<T> consumerInterceptors = ReaderInterceptorUtil.convertToConsumerInterceptors(this, readerConfiguration.getReaderInterceptorList());
        int partitionIdx = TopicName.getPartitionIndex(readerConfiguration.getTopicName());
        this.consumer = new ConsumerImpl(client, readerConfiguration.getTopicName(), consumerConfiguration, executorProvider, partitionIdx, false, false, consumerFuture, readerConfiguration.getStartMessageId(), readerConfiguration.getStartMessageFromRollbackDurationInSec(), schema, consumerInterceptors, true);
    }

    @Override
    public String getTopic() {
        return this.consumer.getTopic();
    }

    public ConsumerImpl<T> getConsumer() {
        return this.consumer;
    }

    @Override
    public boolean hasReachedEndOfTopic() {
        return this.consumer.hasReachedEndOfTopic();
    }

    @Override
    public Message<T> readNext() throws PulsarClientException {
        Message msg = this.consumer.receive();
        this.consumer.acknowledgeCumulativeAsync(msg).exceptionally(ex -> {
            log.warn("[{}][{}] acknowledge message {} cumulative fail.", new Object[]{this.getTopic(), this.getConsumer().getSubscription(), msg.getMessageId(), ex});
            return null;
        });
        return msg;
    }

    @Override
    public Message<T> readNext(int timeout, TimeUnit unit) throws PulsarClientException {
        Message msg = this.consumer.receive(timeout, unit);
        if (msg != null) {
            this.consumer.acknowledgeCumulativeAsync(msg).exceptionally(ex -> {
                log.warn("[{}][{}] acknowledge message {} cumulative fail.", new Object[]{this.getTopic(), this.getConsumer().getSubscription(), msg.getMessageId(), ex});
                return null;
            });
        }
        return msg;
    }

    @Override
    public CompletableFuture<Message<T>> readNextAsync() {
        CompletableFuture originalFuture = this.consumer.receiveAsync();
        CompletionStage result = originalFuture.thenApply(msg -> {
            this.consumer.acknowledgeCumulativeAsync((Message<?>)msg).exceptionally(ex -> {
                log.error("[{}][{}] acknowledge message {} cumulative fail.", new Object[]{this.getTopic(), this.getConsumer().getSubscription(), msg.getMessageId(), ex});
                return null;
            });
            return msg;
        });
        CompletableFutureCancellationHandler handler = new CompletableFutureCancellationHandler();
        handler.attachToFuture((CompletableFuture<?>)result);
        handler.setCancelAction(() -> originalFuture.cancel(false));
        return result;
    }

    @Override
    public void close() throws IOException {
        this.consumer.close();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.consumer.closeAsync();
    }

    @Override
    public boolean hasMessageAvailable() throws PulsarClientException {
        return this.consumer.hasMessageAvailable();
    }

    @Override
    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        return this.consumer.hasMessageAvailableAsync();
    }

    @Override
    public boolean isConnected() {
        return this.consumer.isConnected();
    }

    @Override
    public void seek(MessageId messageId) throws PulsarClientException {
        this.consumer.seek(messageId);
    }

    @Override
    public void seek(long timestamp) throws PulsarClientException {
        this.consumer.seek(timestamp);
    }

    @Override
    public void seek(Function<String, Object> function) throws PulsarClientException {
        this.consumer.seek(function);
    }

    @Override
    public CompletableFuture<Void> seekAsync(Function<String, Object> function) {
        return this.consumer.seekAsync(function);
    }

    @Override
    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        return this.consumer.seekAsync(messageId);
    }

    @Override
    public CompletableFuture<Void> seekAsync(long timestamp) {
        return this.consumer.seekAsync(timestamp);
    }
}

