package org.apache.pulsar.common.api.proto;
public final class CommandTopicMigrated {
	public enum ResourceType {
		Producer(0), Consumer(1),;
		private final int value;
		private ResourceType(int value) {
			this.value = value;
		}
		public int getValue() {
			return value;
		}
		public static ResourceType valueOf(int n) {
			switch (n) {
				case 0 :
					return Producer;
				case 1 :
					return Consumer;
				default :
					return null;

			}
		}
		public static final int Producer_VALUE = 0;
		public static final int Consumer_VALUE = 1;
	}

	private long resourceId;
	private static final int _RESOURCE_ID_FIELD_NUMBER = 1;
	private static final int _RESOURCE_ID_TAG = (_RESOURCE_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _RESOURCE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_RESOURCE_ID_TAG);
	private static final int _RESOURCE_ID_MASK = 1 << (0 % 32);
	public boolean hasResourceId() {
		return (_bitField0 & _RESOURCE_ID_MASK) != 0;
	}
	public long getResourceId() {
		if (!hasResourceId()) {
			throw new IllegalStateException("Field 'resource_id' is not set");
		}
		return resourceId;
	}
	public CommandTopicMigrated setResourceId(long resourceId) {
		this.resourceId = resourceId;
		_bitField0 |= _RESOURCE_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandTopicMigrated clearResourceId() {
		_bitField0 &= ~_RESOURCE_ID_MASK;
		return this;
	}

	private ResourceType resourceType;
	private static final int _RESOURCE_TYPE_FIELD_NUMBER = 2;
	private static final int _RESOURCE_TYPE_TAG = (_RESOURCE_TYPE_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _RESOURCE_TYPE_TAG_SIZE = LightProtoCodec.computeVarIntSize(_RESOURCE_TYPE_TAG);
	private static final int _RESOURCE_TYPE_MASK = 1 << (1 % 32);
	public boolean hasResourceType() {
		return (_bitField0 & _RESOURCE_TYPE_MASK) != 0;
	}
	public ResourceType getResourceType() {
		if (!hasResourceType()) {
			throw new IllegalStateException("Field 'resource_type' is not set");
		}
		return resourceType;
	}
	public CommandTopicMigrated setResourceType(ResourceType resourceType) {
		this.resourceType = resourceType;
		_bitField0 |= _RESOURCE_TYPE_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandTopicMigrated clearResourceType() {
		_bitField0 &= ~_RESOURCE_TYPE_MASK;
		return this;
	}

	private String brokerServiceUrl;
	private int _brokerServiceUrlBufferIdx = -1;
	private int _brokerServiceUrlBufferLen = -1;
	private static final int _BROKER_SERVICE_URL_FIELD_NUMBER = 3;
	private static final int _BROKER_SERVICE_URL_TAG = (_BROKER_SERVICE_URL_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _BROKER_SERVICE_URL_TAG_SIZE = LightProtoCodec.computeVarIntSize(_BROKER_SERVICE_URL_TAG);
	private static final int _BROKER_SERVICE_URL_MASK = 1 << (2 % 32);
	public boolean hasBrokerServiceUrl() {
		return (_bitField0 & _BROKER_SERVICE_URL_MASK) != 0;
	}
	public String getBrokerServiceUrl() {
		if (!hasBrokerServiceUrl()) {
			throw new IllegalStateException("Field 'brokerServiceUrl' is not set");
		}
		if (brokerServiceUrl == null) {
			brokerServiceUrl = LightProtoCodec.readString(_parsedBuffer, _brokerServiceUrlBufferIdx,
					_brokerServiceUrlBufferLen);
		}
		return brokerServiceUrl;
	}
	public CommandTopicMigrated setBrokerServiceUrl(String brokerServiceUrl) {
		this.brokerServiceUrl = brokerServiceUrl;
		_bitField0 |= _BROKER_SERVICE_URL_MASK;
		_brokerServiceUrlBufferIdx = -1;
		_brokerServiceUrlBufferLen = LightProtoCodec.computeStringUTF8Size(brokerServiceUrl);
		_cachedSize = -1;
		return this;
	}
	public CommandTopicMigrated clearBrokerServiceUrl() {
		_bitField0 &= ~_BROKER_SERVICE_URL_MASK;
		brokerServiceUrl = null;
		_brokerServiceUrlBufferIdx = -1;
		_brokerServiceUrlBufferLen = -1;
		return this;
	}

	private String brokerServiceUrlTls;
	private int _brokerServiceUrlTlsBufferIdx = -1;
	private int _brokerServiceUrlTlsBufferLen = -1;
	private static final int _BROKER_SERVICE_URL_TLS_FIELD_NUMBER = 4;
	private static final int _BROKER_SERVICE_URL_TLS_TAG = (_BROKER_SERVICE_URL_TLS_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _BROKER_SERVICE_URL_TLS_TAG_SIZE = LightProtoCodec
			.computeVarIntSize(_BROKER_SERVICE_URL_TLS_TAG);
	private static final int _BROKER_SERVICE_URL_TLS_MASK = 1 << (3 % 32);
	public boolean hasBrokerServiceUrlTls() {
		return (_bitField0 & _BROKER_SERVICE_URL_TLS_MASK) != 0;
	}
	public String getBrokerServiceUrlTls() {
		if (!hasBrokerServiceUrlTls()) {
			throw new IllegalStateException("Field 'brokerServiceUrlTls' is not set");
		}
		if (brokerServiceUrlTls == null) {
			brokerServiceUrlTls = LightProtoCodec.readString(_parsedBuffer, _brokerServiceUrlTlsBufferIdx,
					_brokerServiceUrlTlsBufferLen);
		}
		return brokerServiceUrlTls;
	}
	public CommandTopicMigrated setBrokerServiceUrlTls(String brokerServiceUrlTls) {
		this.brokerServiceUrlTls = brokerServiceUrlTls;
		_bitField0 |= _BROKER_SERVICE_URL_TLS_MASK;
		_brokerServiceUrlTlsBufferIdx = -1;
		_brokerServiceUrlTlsBufferLen = LightProtoCodec.computeStringUTF8Size(brokerServiceUrlTls);
		_cachedSize = -1;
		return this;
	}
	public CommandTopicMigrated clearBrokerServiceUrlTls() {
		_bitField0 &= ~_BROKER_SERVICE_URL_TLS_MASK;
		brokerServiceUrlTls = null;
		_brokerServiceUrlTlsBufferIdx = -1;
		_brokerServiceUrlTlsBufferLen = -1;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0 | _RESOURCE_ID_MASK | _RESOURCE_TYPE_MASK;
	public int writeTo(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _b) {
		checkRequiredFields();
		int _writeIdx = _b.writerIndex();
		LightProtoCodec.writeVarInt(_b, _RESOURCE_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, resourceId);
		LightProtoCodec.writeVarInt(_b, _RESOURCE_TYPE_TAG);
		LightProtoCodec.writeVarInt(_b, resourceType.getValue());
		if (hasBrokerServiceUrl()) {
			LightProtoCodec.writeVarInt(_b, _BROKER_SERVICE_URL_TAG);
			LightProtoCodec.writeVarInt(_b, _brokerServiceUrlBufferLen);
			if (_brokerServiceUrlBufferIdx == -1) {
				LightProtoCodec.writeString(_b, brokerServiceUrl, _brokerServiceUrlBufferLen);
			} else {
				_parsedBuffer.getBytes(_brokerServiceUrlBufferIdx, _b, _brokerServiceUrlBufferLen);
			}
		}
		if (hasBrokerServiceUrlTls()) {
			LightProtoCodec.writeVarInt(_b, _BROKER_SERVICE_URL_TLS_TAG);
			LightProtoCodec.writeVarInt(_b, _brokerServiceUrlTlsBufferLen);
			if (_brokerServiceUrlTlsBufferIdx == -1) {
				LightProtoCodec.writeString(_b, brokerServiceUrlTls, _brokerServiceUrlTlsBufferLen);
			} else {
				_parsedBuffer.getBytes(_brokerServiceUrlTlsBufferIdx, _b, _brokerServiceUrlTlsBufferLen);
			}
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		_size += _RESOURCE_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(resourceId);
		_size += _RESOURCE_TYPE_TAG_SIZE;
		_size += LightProtoCodec.computeVarIntSize(resourceType.getValue());
		if (hasBrokerServiceUrl()) {
			_size += _BROKER_SERVICE_URL_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_brokerServiceUrlBufferLen);
			_size += _brokerServiceUrlBufferLen;
		}
		if (hasBrokerServiceUrlTls()) {
			_size += _BROKER_SERVICE_URL_TLS_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_brokerServiceUrlTlsBufferLen);
			_size += _brokerServiceUrlTlsBufferLen;
		}
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _RESOURCE_ID_TAG :
					_bitField0 |= _RESOURCE_ID_MASK;
					resourceId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _RESOURCE_TYPE_TAG :
					ResourceType _resourceType = ResourceType.valueOf(LightProtoCodec.readVarInt(_buffer));
					if (_resourceType != null) {
						_bitField0 |= _RESOURCE_TYPE_MASK;
						resourceType = _resourceType;
					}
					break;
				case _BROKER_SERVICE_URL_TAG :
					_bitField0 |= _BROKER_SERVICE_URL_MASK;
					_brokerServiceUrlBufferLen = LightProtoCodec.readVarInt(_buffer);
					_brokerServiceUrlBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_brokerServiceUrlBufferLen);
					break;
				case _BROKER_SERVICE_URL_TLS_TAG :
					_bitField0 |= _BROKER_SERVICE_URL_TLS_MASK;
					_brokerServiceUrlTlsBufferLen = LightProtoCodec.readVarInt(_buffer);
					_brokerServiceUrlTlsBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_brokerServiceUrlTlsBufferLen);
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		checkRequiredFields();
		_parsedBuffer = _buffer;
	}
	private void checkRequiredFields() {
		if ((_bitField0 & _REQUIRED_FIELDS_MASK0) != _REQUIRED_FIELDS_MASK0) {
			throw new IllegalStateException("Some required fields are missing");
		}
	}
	public CommandTopicMigrated clear() {
		brokerServiceUrl = null;
		_brokerServiceUrlBufferIdx = -1;
		_brokerServiceUrlBufferLen = -1;
		brokerServiceUrlTls = null;
		_brokerServiceUrlTlsBufferIdx = -1;
		_brokerServiceUrlTlsBufferLen = -1;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public CommandTopicMigrated copyFrom(CommandTopicMigrated _other) {
		_cachedSize = -1;
		if (_other.hasResourceId()) {
			setResourceId(_other.resourceId);
		}
		if (_other.hasResourceType()) {
			setResourceType(_other.resourceType);
		}
		if (_other.hasBrokerServiceUrl()) {
			setBrokerServiceUrl(_other.getBrokerServiceUrl());
		}
		if (_other.hasBrokerServiceUrlTls()) {
			setBrokerServiceUrlTls(_other.getBrokerServiceUrlTls());
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private org.apache.pulsar.shade.io.netty.buffer.ByteBuf _parsedBuffer;

}
