/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.pulsar.shade.org.apache.commons.compress.utils;

import java.io.InputStream;
import java.util.Objects;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

/**
 * Calculates the checksum of the data read.
 *
 * @NotThreadSafe
 * @since 1.14
 * @deprecated Use {@link CheckedInputStream}.
 */
@Deprecated
public class ChecksumCalculatingInputStream extends CheckedInputStream {

    /**
     * Constructs a new instance.
     *
     * @param checksum    The checksum to update
     * @param inputStream The input stream to read.
     * @deprecated Use {@link CheckedInputStream#CheckedInputStream(InputStream, Checksum)}.
     */
    @Deprecated
    @SuppressWarnings("resource")
    public ChecksumCalculatingInputStream(final Checksum checksum, final InputStream inputStream) {
        super(Objects.requireNonNull(inputStream, "inputStream"), Objects.requireNonNull(checksum, "checksum"));
    }

    /**
     * Returns the calculated checksum.
     *
     * @return the calculated checksum.
     * @deprecated Use {@link CheckedInputStream#getChecksum()} and {@link Checksum#getValue()}.
     */
    @Deprecated
    public long getValue() {
        return getChecksum().getValue();
    }

}
