package org.apache.pulsar.shade.org.asynchttpclient.cookie;

import java.util.concurrent.TimeUnit;

import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;

import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.TimerTask;

/**
 * Evicts expired cookies from the {@linkplain CookieStore} periodically.
 * The default delay is 30 seconds. You may override the default using
 * {@linkplain AsyncHttpClientConfig#expiredCookieEvictionDelay()}.
 */
public class CookieEvictionTask implements TimerTask {

    private final long evictDelayInMs;
    private final CookieStore cookieStore;

    public CookieEvictionTask(long evictDelayInMs, CookieStore cookieStore) {
        this.evictDelayInMs = evictDelayInMs;
        this.cookieStore = cookieStore;
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        cookieStore.evictExpired();
        timeout.timer().newTimeout(this, evictDelayInMs, TimeUnit.MILLISECONDS);
    }
}
