package org.apache.pulsar.shade.org.checkerframework.common.reflection.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for methods like {@code Constructor.newInstance}, whose signature is: <br>
 * {@code T method(}{@link MethodVal}{@code (classname=c, methodname="<init>", params=p) Constructor
 * this, Object... args)}
 *
 * @checker_framework.manual #reflection-resolution Reflection resolution
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface NewInstance {}
