/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.PulsarSaslClient;
import org.apache.pulsar.client.impl.auth.SaslAuthenticationDataProvider;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.sasl.JAASCredentialsContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationSasl
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationSasl.class);
    private static final long serialVersionUID = 1L;
    private static JAASCredentialsContainer jaasCredentialsContainer;
    private static volatile boolean initializedJAAS;
    private Map<String, String> configuration;
    private String loginContextName;
    private String serverType = null;
    private String saslRoleToken = null;
    private Client client = null;

    public String getAuthMethodName() {
        return "sasl";
    }

    public AuthenticationDataProvider getAuthData(String serverHostname) throws PulsarClientException {
        try {
            PulsarSaslClient saslClient = new PulsarSaslClient(serverHostname, this.serverType, jaasCredentialsContainer.getSubject());
            return new SaslAuthenticationDataProvider(saslClient);
        }
        catch (Throwable t) {
            log.error("Failed create sasl client", t);
            throw new PulsarClientException(t);
        }
    }

    public void configure(String encodedAuthParamString) {
        if (StringUtils.isBlank((CharSequence)encodedAuthParamString)) {
            log.info("authParams for SASL is be empty, will use default JAAS client section name: {}", (Object)"PulsarClient");
        }
        try {
            this.setAuthParams(AuthenticationUtil.configureFromJsonString((String)encodedAuthParamString));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse SASL authParams", e);
        }
    }

    @Deprecated
    public void configure(Map<String, String> authParams) {
        try {
            this.setAuthParams(authParams);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse SASL authParams", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAuthParams(Map<String, String> authParams) throws PulsarClientException {
        this.configuration = authParams;
        this.loginContextName = authParams.getOrDefault("saslJaasClientSectionName", "PulsarClient");
        this.serverType = authParams.getOrDefault("serverType", "broker");
        if (!initializedJAAS) {
            AuthenticationSasl authenticationSasl = this;
            synchronized (authenticationSasl) {
                if (jaasCredentialsContainer == null) {
                    log.info("JAAS loginContext is: {}.", (Object)this.loginContextName);
                    try {
                        jaasCredentialsContainer = new JAASCredentialsContainer(this.loginContextName, (CallbackHandler)new PulsarSaslClient.ClientCallbackHandler(), this.configuration);
                        initializedJAAS = true;
                    }
                    catch (LoginException e) {
                        log.error("JAAS login in client failed", (Throwable)e);
                        throw new PulsarClientException((Throwable)e);
                    }
                }
            }
        }
    }

    public void start() throws PulsarClientException {
        this.client = ClientBuilder.newClient();
    }

    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    private boolean isRoleTokenExpired(Map<String, String> responseHeaders) {
        return this.saslRoleToken != null && responseHeaders != null && responseHeaders.get("SASL-Type") != null && responseHeaders.get("SASL-Type").equalsIgnoreCase("Kerberos") && responseHeaders.get("State") != null && responseHeaders.get("State").equalsIgnoreCase("SaslAuthRoleTokenExpired");
    }

    private Invocation.Builder newRequestBuilder(WebTarget target, AuthenticationDataProvider authData, Map<String, String> previousResHeaders) {
        Invocation.Builder builder = target.request(new String[]{"application/json"});
        Set<Map.Entry<String, String>> headers = this.newRequestHeader(target.getUri().toString(), authData, previousResHeaders);
        headers.forEach(entry -> builder.header((String)entry.getKey(), entry.getValue()));
        return builder;
    }

    public Set<Map.Entry<String, String>> newRequestHeader(String hostName, AuthenticationDataProvider authData, Map<String, String> previousRespHeaders) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (authData.hasDataForHttp()) {
            authData.getHttpHeaders().forEach(header -> headers.put((String)header.getKey(), (String)header.getValue()));
        }
        if (this.isRoleTokenExpired(previousRespHeaders)) {
            previousRespHeaders = null;
            this.saslRoleToken = null;
            authData = this.getAuthData(hostName);
        }
        if (this.saslRoleToken != null) {
            headers.put("SaslAuthRoleToken", this.saslRoleToken);
            if (previousRespHeaders == null) {
                if (log.isDebugEnabled()) {
                    log.debug("request builder add token: Check token");
                }
                headers.put("State", "ServerCheckToken");
            } else if (previousRespHeaders.get("State").equalsIgnoreCase("Done")) {
                headers.put("State", "Done");
                if (log.isDebugEnabled()) {
                    log.debug("request builder add token. role verified by server");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("request builder add token. NOT complete. state: {}", (Object)previousRespHeaders.get("State"));
                }
                headers.put("State", "ING");
            }
            return headers.entrySet();
        }
        if (previousRespHeaders == null) {
            if (log.isDebugEnabled()) {
                log.debug("Init authn in client side");
            }
            headers.put("State", "Init");
            AuthData initData = authData.authenticate(AuthData.INIT_AUTH_DATA);
            headers.put("SASL-Token", Base64.getEncoder().encodeToString(initData.getBytes()));
        } else {
            AuthData brokerData = AuthData.of((byte[])Base64.getDecoder().decode(previousRespHeaders.get("SASL-Token")));
            AuthData clientData = authData.authenticate(brokerData);
            headers.put("SASL-Server-ID", previousRespHeaders.get("SASL-Server-ID"));
            headers.put("SASL-Type", "Kerberos");
            headers.put("State", "ING");
            headers.put("SASL-Token", Base64.getEncoder().encodeToString(clientData.getBytes()));
        }
        return headers.entrySet();
    }

    private Map<String, String> getHeaders(Response response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String saslHeader = response.getHeaderString("SASL-Type");
        String headerState = response.getHeaderString("State");
        String authToken = response.getHeaderString("SASL-Token");
        String serverStateId = response.getHeaderString("SASL-Server-ID");
        if (this.saslRoleToken != null) {
            headers.put("SaslAuthRoleToken", this.saslRoleToken);
        }
        headers.put("SASL-Type", saslHeader);
        headers.put("State", headerState);
        headers.put("SASL-Token", authToken);
        headers.put("SASL-Server-ID", serverStateId);
        return headers;
    }

    public void authenticationStage(final String requestUrl, final AuthenticationDataProvider authData, Map<String, String> previousResHeaders, final CompletableFuture<Map<String, String>> authFuture) {
        Invocation.Builder builder = this.newRequestBuilder(this.client.target(requestUrl), authData, previousResHeaders);
        builder.async().get((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() == 401) {
                    AuthenticationSasl.this.authenticationStage(requestUrl, authData, AuthenticationSasl.this.getHeaders(response), authFuture);
                    return;
                }
                if (response.getStatus() != 200) {
                    log.warn("HTTP get request failed: {}", (Object)response.getStatusInfo());
                    authFuture.completeExceptionally((Throwable)new PulsarClientException("Sasl Auth request failed: " + response.getStatus()));
                    return;
                }
                if (response.getHeaderString("SaslAuthRoleToken") != null) {
                    AuthenticationSasl.this.saslRoleToken = response.getHeaderString("SaslAuthRoleToken");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Complete auth with saslRoleToken: {}", (Object)AuthenticationSasl.this.saslRoleToken);
                }
                authFuture.complete(AuthenticationSasl.this.getHeaders(response));
            }

            public void failed(Throwable throwable) {
                log.warn("Failed to perform http request", throwable);
                authFuture.completeExceptionally((Throwable)new PulsarClientException(throwable));
            }
        });
    }

    static {
        initializedJAAS = false;
    }
}

