/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.CmdUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.ClusterPolicies;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;

@Parameters(commandDescription="Operations about clusters")
public class CmdClusters
extends CmdBase {
    protected void validateClusterData(ClusterData clusterData) {
        if (clusterData.isBrokerClientTlsEnabled() && clusterData.isBrokerClientTlsEnabledWithKeyStore() && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{clusterData.getBrokerClientTlsTrustStoreType(), clusterData.getBrokerClientTlsTrustStore(), clusterData.getBrokerClientTlsTrustStorePassword()})) {
            throw new RuntimeException("You must specify tls-trust-store-type, tls-trust-store and tls-trust-store-pwd when enable tls-enable-keystore");
        }
    }

    public CmdClusters(Supplier<PulsarAdmin> admin) {
        super("clusters", admin);
        this.jcommander.addCommand("get", (Object)new Get());
        this.jcommander.addCommand("create", (Object)new Create());
        this.jcommander.addCommand("update", (Object)new Update());
        this.jcommander.addCommand("delete", (Object)new Delete());
        this.jcommander.addCommand("list", (Object)new List());
        this.jcommander.addCommand("update-peer-clusters", (Object)new UpdatePeerClusters());
        this.jcommander.addCommand("get-cluster-migration", (Object)new GetClusterMigration());
        this.jcommander.addCommand("update-cluster-migration", (Object)new UpdateClusterMigration());
        this.jcommander.addCommand("get-peer-clusters", (Object)new GetPeerClusters());
        this.jcommander.addCommand("get-failure-domain", (Object)new GetFailureDomain());
        this.jcommander.addCommand("create-failure-domain", (Object)new CreateFailureDomain());
        this.jcommander.addCommand("update-failure-domain", (Object)new UpdateFailureDomain());
        this.jcommander.addCommand("delete-failure-domain", (Object)new DeleteFailureDomain());
        this.jcommander.addCommand("list-failure-domains", (Object)new ListFailureDomains());
    }

    @Parameters(commandDescription="Get the configuration data for the specified cluster")
    private class Get
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;

        private Get() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = Get.getOneArgument(this.params);
            this.print(CmdClusters.this.getAdmin().clusters().getCluster(cluster));
        }
    }

    @Parameters(commandDescription="Provisions a new cluster. This operation requires Pulsar super-user privileges")
    private class Create
    extends ClusterDetailsCommand {
        private Create() {
        }

        @Override
        void runCmd() throws Exception {
            String cluster = Create.getOneArgument(this.params);
            CmdClusters.this.getAdmin().clusters().createCluster(cluster, this.clusterData);
        }
    }

    @Parameters(commandDescription="Update the configuration for a cluster")
    private class Update
    extends ClusterDetailsCommand {
        private Update() {
        }

        @Override
        void runCmd() throws Exception {
            String cluster = Update.getOneArgument(this.params);
            CmdClusters.this.getAdmin().clusters().updateCluster(cluster, this.clusterData);
        }
    }

    @Parameters(commandDescription="Deletes an existing cluster")
    private class Delete
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"-a", "--all"}, description="Delete all data (tenants) of the cluster", required=false)
        private boolean deleteAll = false;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = Delete.getOneArgument(this.params);
            if (this.deleteAll) {
                for (String tenant : CmdClusters.this.getAdmin().tenants().getTenants()) {
                    for (String namespace : CmdClusters.this.getAdmin().namespaces().getNamespaces(tenant)) {
                        for (String topic : CmdClusters.this.getAdmin().topics().getPartitionedTopicList(namespace)) {
                            CmdClusters.this.getAdmin().topics().deletePartitionedTopic(topic, true, true);
                        }
                        for (String topic : CmdClusters.this.getAdmin().topics().getList(namespace)) {
                            CmdClusters.this.getAdmin().topics().delete(topic, true, true);
                        }
                        CmdClusters.this.getAdmin().namespaces().deleteNamespace(namespace, true);
                    }
                    CmdClusters.this.getAdmin().tenants().deleteTenant(tenant);
                }
            }
            CmdClusters.this.getAdmin().clusters().deleteCluster(cluster);
        }
    }

    @Parameters(commandDescription="List the existing clusters")
    private class List
    extends CliCommand {
        @Parameter(names={"-c", "--current"}, description="Print the current cluster with (*)", required=false)
        private boolean current = false;

        private List() {
        }

        @Override
        void run() throws PulsarAdminException {
            java.util.List clusters = CmdClusters.this.getAdmin().clusters().getClusters();
            String clusterName = (String)CmdClusters.this.getAdmin().brokers().getRuntimeConfigurations().get("clusterName");
            java.util.List result = clusters.stream().map(c -> c.equals(clusterName) ? (this.current ? c + "(*)" : c) : c).collect(Collectors.toList());
            this.print(result);
        }
    }

    @Parameters(commandDescription="Update peer cluster names")
    private class UpdatePeerClusters
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--peer-clusters"}, description="Comma separated peer-cluster names [Pass empty string \"\" to delete list]", required=true)
        private String peerClusterNames;

        private UpdatePeerClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = UpdatePeerClusters.getOneArgument(this.params);
            LinkedHashSet clusters = StringUtils.isBlank((CharSequence)this.peerClusterNames) ? null : Sets.newLinkedHashSet(Arrays.asList(this.peerClusterNames.split(",")));
            CmdClusters.this.getAdmin().clusters().updatePeerClusterNames(cluster, clusters);
        }
    }

    @Parameters(commandDescription="Get the cluster migration configuration data for the specified cluster")
    private class GetClusterMigration
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;

        private GetClusterMigration() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = GetClusterMigration.getOneArgument(this.params);
            this.print(CmdClusters.this.getAdmin().clusters().getClusterMigration(cluster));
        }
    }

    @Parameters(commandDescription="Update cluster migration")
    private class UpdateClusterMigration
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--migrated"}, description="Is cluster migrated")
        private boolean migrated;
        @Parameter(names={"--service-url"}, description="New migrated cluster service url")
        private String serviceUrl;
        @Parameter(names={"--service-url-secure"}, description="New migrated cluster service url secure")
        private String serviceUrlTls;
        @Parameter(names={"--broker-url"}, description="New migrated cluster broker service url")
        private String brokerServiceUrl;
        @Parameter(names={"--broker-url-secure"}, description="New migrated cluster broker service url secure")
        private String brokerServiceUrlTls;

        private UpdateClusterMigration() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = UpdateClusterMigration.getOneArgument(this.params);
            ClusterPolicies.ClusterUrl clusterUrl = new ClusterPolicies.ClusterUrl(this.serviceUrl, this.serviceUrlTls, this.brokerServiceUrl, this.brokerServiceUrlTls);
            CmdClusters.this.getAdmin().clusters().updateClusterMigration(cluster, this.migrated, clusterUrl);
        }
    }

    @Parameters(commandDescription="Get list of peer-clusters")
    private class GetPeerClusters
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;

        private GetPeerClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = GetPeerClusters.getOneArgument(this.params);
            this.print(CmdClusters.this.getAdmin().clusters().getPeerClusterNames(cluster));
        }
    }

    @Parameters(commandDescription="Get the configuration brokers of a failure-domain")
    private class GetFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;

        private GetFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = GetFailureDomain.getOneArgument(this.params);
            this.print(CmdClusters.this.getAdmin().clusters().getFailureDomain(cluster, this.domainName));
        }
    }

    @Parameters(commandDescription="Create a new failure-domain for a cluster. updates it if already created.")
    private class CreateFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;
        @Parameter(names={"--broker-list"}, description="Comma separated broker list", required=false)
        private String brokerList;

        private CreateFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = CreateFailureDomain.getOneArgument(this.params);
            FailureDomainImpl domain = FailureDomainImpl.builder().brokers(StringUtils.isNotBlank((CharSequence)this.brokerList) ? Sets.newHashSet((Object[])this.brokerList.split(",")) : null).build();
            CmdClusters.this.getAdmin().clusters().createFailureDomain(cluster, this.domainName, (FailureDomain)domain);
        }
    }

    @Parameters(commandDescription="Update failure-domain for a cluster. Creates a new one if not exist.")
    private class UpdateFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;
        @Parameter(names={"--broker-list"}, description="Comma separated broker list", required=false)
        private String brokerList;

        private UpdateFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = UpdateFailureDomain.getOneArgument(this.params);
            FailureDomainImpl domain = FailureDomainImpl.builder().brokers(StringUtils.isNotBlank((CharSequence)this.brokerList) ? Sets.newHashSet((Object[])this.brokerList.split(",")) : null).build();
            CmdClusters.this.getAdmin().clusters().updateFailureDomain(cluster, this.domainName, (FailureDomain)domain);
        }
    }

    @Parameters(commandDescription="Deletes an existing failure-domain")
    private class DeleteFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;

        private DeleteFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = DeleteFailureDomain.getOneArgument(this.params);
            CmdClusters.this.getAdmin().clusters().deleteFailureDomain(cluster, this.domainName);
        }
    }

    @Parameters(commandDescription="List the existing failure-domains for a cluster")
    private class ListFailureDomains
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;

        private ListFailureDomains() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = ListFailureDomains.getOneArgument(this.params);
            this.print(CmdClusters.this.getAdmin().clusters().getFailureDomains(cluster));
        }
    }

    abstract class ClusterDetailsCommand
    extends BaseCommand {
        @Parameter(description="cluster-name", required=true)
        protected java.util.List<String> params;
        @Parameter(names={"--url"}, description="service-url", required=false)
        protected String serviceUrl;
        @Parameter(names={"--url-secure"}, description="service-url for secure connection", required=false)
        protected String serviceUrlTls;
        @Parameter(names={"--broker-url"}, description="broker-service-url", required=false)
        protected String brokerServiceUrl;
        @Parameter(names={"--broker-url-secure"}, description="broker-service-url for secure connection", required=false)
        protected String brokerServiceUrlTls;
        @Parameter(names={"--proxy-url"}, description="Proxy-service url when client would like to connect to broker via proxy.")
        protected String proxyServiceUrl;
        @Parameter(names={"--auth-plugin"}, description="authentication plugin", required=false)
        protected String authenticationPlugin;
        @Parameter(names={"--auth-parameters"}, description="authentication parameters", required=false)
        protected String authenticationParameters;
        @Parameter(names={"--proxy-protocol"}, description="protocol to decide type of proxy routing eg: SNI", required=false)
        protected ProxyProtocol proxyProtocol;
        @Parameter(names={"--tls-enable"}, description="Enable tls connection", required=false)
        protected Boolean brokerClientTlsEnabled;
        @Parameter(names={"--tls-allow-insecure"}, description="Allow insecure tls connection", required=false)
        protected Boolean tlsAllowInsecureConnection;
        @Parameter(names={"--tls-enable-keystore"}, description="Whether use KeyStore type to authenticate", required=false)
        protected Boolean brokerClientTlsEnabledWithKeyStore;
        @Parameter(names={"--tls-trust-store-type"}, description="TLS TrustStore type configuration for internal client eg: JKS", required=false)
        protected String brokerClientTlsTrustStoreType;
        @Parameter(names={"--tls-trust-store"}, description="TLS TrustStore path for internal client", required=false)
        protected String brokerClientTlsTrustStore;
        @Parameter(names={"--tls-trust-store-pwd"}, description="TLS TrustStore password for internal client", required=false)
        protected String brokerClientTlsTrustStorePassword;
        @Parameter(names={"--tls-key-store-type"}, description="TLS TrustStore type configuration for internal client eg: JKS", required=false)
        protected String brokerClientTlsKeyStoreType;
        @Parameter(names={"--tls-key-store"}, description="TLS KeyStore path for internal client", required=false)
        protected String brokerClientTlsKeyStore;
        @Parameter(names={"--tls-key-store-pwd"}, description="TLS KeyStore password for internal client", required=false)
        protected String brokerClientTlsKeyStorePassword;
        @Parameter(names={"--tls-trust-certs-filepath"}, description="path for the trusted TLS certificate file", required=false)
        protected String brokerClientTrustCertsFilePath;
        @Parameter(names={"--tls-key-filepath"}, description="path for the TLS private key file", required=false)
        protected String brokerClientKeyFilePath;
        @Parameter(names={"--tls-certs-filepath"}, description="path for the TLS certificate file", required=false)
        protected String brokerClientCertificateFilePath;
        @Parameter(names={"--listener-name"}, description="listenerName when client would like to connect to cluster", required=false)
        protected String listenerName;
        @Parameter(names={"--cluster-config-file"}, description="The path to a YAML config file specifying the cluster's configuration")
        protected String clusterConfigFile;
        protected ClusterData clusterData;

        ClusterDetailsCommand() {
        }

        @Override
        void processArguments() throws Exception {
            super.processArguments();
            ClusterData.Builder builder = null != this.clusterConfigFile ? (ClusterData.Builder)CmdUtils.loadConfig(this.clusterConfigFile, ClusterDataImpl.ClusterDataImplBuilder.class) : ClusterData.builder();
            if (this.serviceUrl != null) {
                builder.serviceUrl(this.serviceUrl);
            }
            if (this.serviceUrlTls != null) {
                builder.serviceUrlTls(this.serviceUrlTls);
            }
            if (this.brokerServiceUrl != null) {
                builder.brokerServiceUrl(this.brokerServiceUrl);
            }
            if (this.brokerServiceUrlTls != null) {
                builder.brokerServiceUrlTls(this.brokerServiceUrlTls);
            }
            if (this.proxyServiceUrl != null) {
                builder.proxyServiceUrl(this.proxyServiceUrl);
            }
            if (this.authenticationPlugin != null) {
                builder.authenticationPlugin(this.authenticationPlugin);
            }
            if (this.authenticationParameters != null) {
                builder.authenticationParameters(this.authenticationParameters);
            }
            if (this.proxyProtocol != null) {
                builder.proxyProtocol(this.proxyProtocol);
            }
            if (this.brokerClientTlsEnabled != null) {
                builder.brokerClientTlsEnabled(this.brokerClientTlsEnabled.booleanValue());
            }
            if (this.tlsAllowInsecureConnection != null) {
                builder.tlsAllowInsecureConnection(this.tlsAllowInsecureConnection.booleanValue());
            }
            if (this.brokerClientTlsEnabledWithKeyStore != null) {
                builder.brokerClientTlsEnabledWithKeyStore(this.brokerClientTlsEnabledWithKeyStore.booleanValue());
            }
            if (this.brokerClientTlsTrustStoreType != null) {
                builder.brokerClientTlsTrustStoreType(this.brokerClientTlsTrustStoreType);
            }
            if (this.brokerClientTlsTrustStore != null) {
                builder.brokerClientTlsTrustStore(this.brokerClientTlsTrustStore);
            }
            if (this.brokerClientTlsTrustStorePassword != null) {
                builder.brokerClientTlsTrustStorePassword(this.brokerClientTlsTrustStorePassword);
            }
            if (this.brokerClientTlsKeyStoreType != null) {
                builder.brokerClientTlsKeyStoreType(this.brokerClientTlsKeyStoreType);
            }
            if (this.brokerClientTlsKeyStore != null) {
                builder.brokerClientTlsKeyStore(this.brokerClientTlsKeyStore);
            }
            if (this.brokerClientTlsKeyStorePassword != null) {
                builder.brokerClientTlsKeyStorePassword(this.brokerClientTlsKeyStorePassword);
            }
            if (this.brokerClientTrustCertsFilePath != null) {
                builder.brokerClientTrustCertsFilePath(this.brokerClientTrustCertsFilePath);
            }
            if (this.brokerClientKeyFilePath != null) {
                builder.brokerClientKeyFilePath(this.brokerClientKeyFilePath);
            }
            if (this.brokerClientCertificateFilePath != null) {
                builder.brokerClientCertificateFilePath(this.brokerClientCertificateFilePath);
            }
            if (this.listenerName != null) {
                builder.listenerName(this.listenerName);
            }
            this.clusterData = builder.build();
            CmdClusters.this.validateClusterData(this.clusterData);
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            try {
                this.processArguments();
            }
            catch (Exception e) {
                String chosenCommand = CmdClusters.this.jcommander.getParsedCommand();
                CmdClusters.this.getUsageFormatter().usage(chosenCommand);
                throw e;
            }
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

