/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.keystoretls;

import com.google.common.base.Strings;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreSSLContext {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreSSLContext.class);
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final String DEFAULT_SSL_ENABLED_PROTOCOLS = "TLSv1.3,TLSv1.2";
    public static final String DEFAULT_SSL_KEYMANGER_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    public static final String DEFAULT_SSL_TRUSTMANAGER_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    public static final Provider BC_PROVIDER = SecurityUtility.getProvider();
    private final Mode mode;
    private final String sslProviderString;
    private final String keyStoreTypeString;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final boolean allowInsecureConnection;
    private final String trustStoreTypeString;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean needClientAuth;
    private final Set<String> ciphers;
    private final Set<String> protocols;
    private SSLContext sslContext;
    private final String protocol = "TLS";
    private final String kmfAlgorithm = DEFAULT_SSL_KEYMANGER_ALGORITHM;
    private final String tmfAlgorithm = DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;

    public KeyStoreSSLContext(Mode mode, String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols) {
        this.mode = mode;
        this.sslProviderString = sslProviderString;
        this.keyStoreTypeString = Strings.isNullOrEmpty((String)keyStoreTypeString) ? DEFAULT_KEYSTORE_TYPE : keyStoreTypeString;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStoreTypeString = Strings.isNullOrEmpty((String)trustStoreTypeString) ? DEFAULT_KEYSTORE_TYPE : trustStoreTypeString;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword == null ? "" : trustStorePassword;
        this.needClientAuth = requireTrustedClientCertOnConnect;
        this.protocols = protocols != null && protocols.size() > 0 ? protocols : new HashSet<String>(Arrays.asList(DEFAULT_SSL_ENABLED_PROTOCOLS.split("\\s*,\\s*")));
        this.ciphers = ciphers != null && ciphers.size() > 0 ? ciphers : null;
        this.allowInsecureConnection = allowInsecureConnection;
    }

    public SSLContext createSSLContext() throws GeneralSecurityException, IOException {
        FileInputStream inputStream;
        char[] passwordChars;
        Provider provider = SecurityUtility.resolveProvider(this.sslProviderString);
        SSLContext sslContext = provider != null ? SSLContext.getInstance(DEFAULT_SSL_PROTOCOL, provider) : SSLContext.getInstance(DEFAULT_SSL_PROTOCOL);
        KeyManager[] keyManagers = null;
        if (!Strings.isNullOrEmpty((String)this.keyStorePath)) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.kmfAlgorithm);
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreTypeString);
            passwordChars = this.keyStorePassword.toCharArray();
            inputStream = new FileInputStream(this.keyStorePath);
            try {
                keyStore.load(inputStream, passwordChars);
            }
            finally {
                inputStream.close();
            }
            keyManagerFactory.init(keyStore, passwordChars);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        TrustManagerFactory trustManagerFactory = null;
        if (this.allowInsecureConnection) {
            trustManagerFactory = InsecureTrustManagerFactory.INSTANCE;
        } else if (!Strings.isNullOrEmpty((String)this.trustStorePath)) {
            trustManagerFactory = provider != null ? TrustManagerFactory.getInstance(this.tmfAlgorithm, provider) : TrustManagerFactory.getInstance(this.tmfAlgorithm);
            KeyStore trustStore = KeyStore.getInstance(this.trustStoreTypeString);
            passwordChars = this.trustStorePassword.toCharArray();
            inputStream = new FileInputStream(this.trustStorePath);
            try {
                trustStore.load(inputStream, passwordChars);
            }
            finally {
                inputStream.close();
            }
            trustManagerFactory.init(trustStore);
        }
        TrustManager[] trustManagers = null;
        if (trustManagerFactory != null) {
            trustManagers = SecurityUtility.processConscryptTrustManagers(trustManagerFactory.getTrustManagers());
        }
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        this.sslContext = sslContext;
        return sslContext;
    }

    public SSLContext getSslContext() {
        if (this.sslContext == null) {
            throw new IllegalStateException("createSSLContext hasn't been called.");
        }
        return this.sslContext;
    }

    public SSLEngine createSSLEngine() {
        return this.configureSSLEngine(this.getSslContext().createSSLEngine());
    }

    public SSLEngine createSSLEngine(String peerHost, int peerPort) {
        return this.configureSSLEngine(this.getSslContext().createSSLEngine(peerHost, peerPort));
    }

    private SSLEngine configureSSLEngine(SSLEngine sslEngine) {
        sslEngine.setEnabledProtocols(this.protocols.toArray(new String[0]));
        if (this.ciphers != null) {
            sslEngine.setEnabledCipherSuites(this.ciphers.toArray(new String[0]));
        }
        if (this.mode == Mode.SERVER) {
            if (this.needClientAuth) {
                sslEngine.setNeedClientAuth(true);
            } else {
                sslEngine.setWantClientAuth(true);
            }
            sslEngine.setUseClientMode(false);
        } else {
            sslEngine.setUseClientMode(true);
        }
        return sslEngine;
    }

    public static KeyStoreSSLContext createClientKeyStoreSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.CLIENT, sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, false, ciphers, protocols);
        keyStoreSSLContext.createSSLContext();
        return keyStoreSSLContext;
    }

    public static KeyStoreSSLContext createServerKeyStoreSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, boolean requireTrustedClientCertOnConnect, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.SERVER, sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, requireTrustedClientCertOnConnect, ciphers, protocols);
        keyStoreSSLContext.createSSLContext();
        return keyStoreSSLContext;
    }

    public static SSLContext createServerSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, boolean requireTrustedClientCertOnConnect) throws GeneralSecurityException, IOException {
        return KeyStoreSSLContext.createServerKeyStoreSslContext(sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, requireTrustedClientCertOnConnect, null, null).getSslContext();
    }

    public static SSLContext createClientSslContext(String sslProviderString, String keyStoreTypeString, String keyStorePath, String keyStorePassword, boolean allowInsecureConnection, String trustStoreTypeString, String trustStorePath, String trustStorePassword, Set<String> ciphers, Set<String> protocol) throws GeneralSecurityException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.CLIENT, sslProviderString, keyStoreTypeString, keyStorePath, keyStorePassword, allowInsecureConnection, trustStoreTypeString, trustStorePath, trustStorePassword, false, ciphers, protocol);
        return keyStoreSSLContext.createSSLContext();
    }

    public static SSLContext createClientSslContext(String keyStoreTypeString, String keyStorePath, String keyStorePassword, String trustStoreTypeString, String trustStorePath, String trustStorePassword) throws GeneralSecurityException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = new KeyStoreSSLContext(Mode.CLIENT, null, keyStoreTypeString, keyStorePath, keyStorePassword, false, trustStoreTypeString, trustStorePath, trustStorePassword, false, null, null);
        return keyStoreSSLContext.createSSLContext();
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

