/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.common.functions.CryptoConfig;
import org.apache.pulsar.common.util.ClassLoaderUtils;
import org.apache.pulsar.functions.proto.Function;

public final class CryptoUtils {
    public static Function.CryptoSpec convert(CryptoConfig config) {
        Function.CryptoSpec.Builder bldr = Function.CryptoSpec.newBuilder().setCryptoKeyReaderClassName(config.getCryptoKeyReaderClassName());
        if (config.getCryptoKeyReaderConfig() != null) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            String readerConfigString = new Gson().toJson((Object)config.getCryptoKeyReaderConfig(), type);
            bldr.setCryptoKeyReaderConfig(readerConfigString);
        }
        if (config.getEncryptionKeys() != null && config.getEncryptionKeys().length > 0) {
            bldr.addAllProducerEncryptionKeyName(Arrays.asList(config.getEncryptionKeys()));
        }
        if (config.getProducerCryptoFailureAction() != null) {
            bldr.setProducerCryptoFailureAction(CryptoUtils.getProtoFailureAction(config.getProducerCryptoFailureAction()));
        }
        if (config.getConsumerCryptoFailureAction() != null) {
            bldr.setConsumerCryptoFailureAction(CryptoUtils.getProtoFailureAction(config.getConsumerCryptoFailureAction()));
        }
        return bldr.build();
    }

    public static CryptoConfig convertFromSpec(Function.CryptoSpec spec) {
        if (spec == null || StringUtils.isEmpty((String)spec.getCryptoKeyReaderClassName())) {
            return null;
        }
        CryptoConfig.CryptoConfigBuilder bldr = CryptoConfig.builder();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map cryptoReaderConfig = (Map)new Gson().fromJson(spec.getCryptoKeyReaderConfig(), type);
        bldr.cryptoKeyReaderClassName(spec.getCryptoKeyReaderClassName()).cryptoKeyReaderConfig(cryptoReaderConfig).consumerCryptoFailureAction(CryptoUtils.getConsumerCryptoFailureAction(spec.getConsumerCryptoFailureAction())).producerCryptoFailureAction(CryptoUtils.getProducerCryptoFailureAction(spec.getProducerCryptoFailureAction())).encryptionKeys((String[])spec.getProducerEncryptionKeyNameList().toArray((Object[])new String[0]));
        return bldr.build();
    }

    public static CryptoKeyReader getCryptoKeyReaderInstance(String className, Map<String, Object> configs, ClassLoader classLoader) {
        Class cryptoClass;
        try {
            cryptoClass = ClassLoaderUtils.loadClass((String)className, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Failed to load crypto key reader class %sx", className));
        }
        try {
            Constructor ctor = cryptoClass.getConstructor(Map.class);
            return (CryptoKeyReader)ctor.newInstance(configs);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Key reader class does not have constructor accepts map", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create instance for key reader class", e);
        }
    }

    public static ProducerCryptoFailureAction getProducerCryptoFailureAction(Function.CryptoSpec.FailureAction action) {
        switch (action) {
            case FAIL: {
                return ProducerCryptoFailureAction.FAIL;
            }
            case SEND: {
                return ProducerCryptoFailureAction.SEND;
            }
        }
        throw new RuntimeException("Unknown producer protobuf failure action " + action.getValueDescriptor().getName());
    }

    public static ConsumerCryptoFailureAction getConsumerCryptoFailureAction(Function.CryptoSpec.FailureAction action) {
        switch (action) {
            case FAIL: {
                return ConsumerCryptoFailureAction.FAIL;
            }
            case DISCARD: {
                return ConsumerCryptoFailureAction.DISCARD;
            }
            case CONSUME: {
                return ConsumerCryptoFailureAction.CONSUME;
            }
        }
        throw new RuntimeException("Unknown consumer protobuf failure action " + action.getValueDescriptor().getName());
    }

    public static Function.CryptoSpec.FailureAction getProtoFailureAction(ProducerCryptoFailureAction action) {
        switch (action) {
            case FAIL: {
                return Function.CryptoSpec.FailureAction.FAIL;
            }
            case SEND: {
                return Function.CryptoSpec.FailureAction.SEND;
            }
        }
        throw new RuntimeException("Unknown producer crypto failure action " + action);
    }

    public static Function.CryptoSpec.FailureAction getProtoFailureAction(ConsumerCryptoFailureAction action) {
        switch (action) {
            case FAIL: {
                return Function.CryptoSpec.FailureAction.FAIL;
            }
            case DISCARD: {
                return Function.CryptoSpec.FailureAction.DISCARD;
            }
            case CONSUME: {
                return Function.CryptoSpec.FailureAction.CONSUME;
            }
        }
        throw new RuntimeException("Unknown consumer crypto failure action " + action);
    }
}

