/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.canal;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.FlatMessage;
import com.alibaba.otter.canal.protocol.Message;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MessageUtils {
    public static Map<String, String> genColumn(CanalEntry.Column column) {
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        if (column.getIsKey()) {
            row.put("isKey", "1");
        } else {
            row.put("isKey", "0");
        }
        if (column.getIsNull()) {
            row.put("isNull", "1");
        } else {
            row.put("isNull", "0");
        }
        row.put("index", Integer.toString(column.getIndex()));
        row.put("mysqlType", column.getMysqlType());
        row.put("columnName", column.getName());
        if (column.getIsNull()) {
            row.put("columnValue", null);
        } else {
            row.put("columnValue", column.getValue());
        }
        return row;
    }

    public static List<FlatMessage> messageConverter(Message message) {
        try {
            if (message == null) {
                return null;
            }
            ArrayList<FlatMessage> flatMessages = new ArrayList<FlatMessage>();
            ArrayList<CanalEntry.Entry> entrys = null;
            if (message.isRaw()) {
                List rawEntries = message.getRawEntries();
                entrys = new ArrayList<CanalEntry.Entry>(rawEntries.size());
                for (ByteString byteString : rawEntries) {
                    CanalEntry.Entry entry = CanalEntry.Entry.parseFrom((ByteString)byteString);
                    entrys.add(entry);
                }
            } else {
                entrys = message.getEntries();
            }
            for (CanalEntry.Entry entry : entrys) {
                CanalEntry.RowChange rowChange;
                if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) continue;
                try {
                    rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
                }
                catch (Exception e) {
                    throw new RuntimeException("ERROR ## parser of eromanga-event has an error, data:" + entry.toString(), e);
                }
                CanalEntry.EventType eventType = rowChange.getEventType();
                FlatMessage flatMessage = new FlatMessage(message.getId());
                flatMessages.add(flatMessage);
                flatMessage.setDatabase(entry.getHeader().getSchemaName());
                flatMessage.setTable(entry.getHeader().getTableName());
                flatMessage.setIsDdl(Boolean.valueOf(rowChange.getIsDdl()));
                flatMessage.setType(eventType.toString());
                flatMessage.setEs(Long.valueOf(entry.getHeader().getExecuteTime()));
                flatMessage.setTs(Long.valueOf(System.currentTimeMillis()));
                flatMessage.setSql(rowChange.getSql());
                if (rowChange.getIsDdl()) continue;
                ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
                ArrayList<Map<String, String>> old = new ArrayList<Map<String, String>>();
                for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                    if (eventType != CanalEntry.EventType.INSERT && eventType != CanalEntry.EventType.UPDATE && eventType != CanalEntry.EventType.DELETE) continue;
                    List columns = eventType == CanalEntry.EventType.DELETE ? rowData.getBeforeColumnsList() : rowData.getAfterColumnsList();
                    columns.size();
                    for (CanalEntry.Column column : columns) {
                        Map<String, String> row = MessageUtils.genColumn(column);
                        if (column.getUpdated()) {
                            row.put("updated", "1");
                        } else {
                            row.put("updated", "0");
                        }
                        data.add(row);
                    }
                    if (eventType != CanalEntry.EventType.UPDATE) continue;
                    for (CanalEntry.Column column : rowData.getBeforeColumnsList()) {
                        Map<String, String> rowOld = MessageUtils.genColumn(column);
                        old.add(rowOld);
                    }
                }
                if (!data.isEmpty()) {
                    flatMessage.setData(data);
                }
                if (old.isEmpty()) continue;
                flatMessage.setOld(old);
            }
            return flatMessages;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

