/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.elasticsearch.ElasticSearchSslConfig;
import org.apache.pulsar.io.elasticsearch.IndexNameFormatter;

public class ElasticSearchConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The url of elastic search cluster that the connector connects to")
    private String elasticSearchUrl;
    @FieldDoc(required=false, defaultValue="", help="The index name to which the connector writes messages. The default value is the topic name. It accepts date formats in the name to support event time based index with the pattern %{+<date-format>}. For example, suppose the event time of the record is 1645182000000L, the indexName is \"logs-%{+yyyy-MM-dd}\", then the formatted index name would be \"logs-2022-02-18\".")
    private String indexName;
    @FieldDoc(required=false, defaultValue="_doc", help="The type name that the connector writes messages to, with the default value set to _doc. This value should be set explicitly to a valid type name other than _doc for Elasticsearch version before 6.2, and left to the default value otherwise.")
    private String typeName = "_doc";
    @FieldDoc(required=false, defaultValue="false", help="Sets whether the Sink has to take into account the Schema or if it should simply copy the raw message to Elastichsearch")
    private boolean schemaEnable = false;
    @FieldDoc(required=false, defaultValue="1", help="The number of shards of the index")
    private int indexNumberOfShards = 1;
    @FieldDoc(required=false, defaultValue="false", help="Create the index if it does not exist")
    private boolean createIndexIfNeeded = false;
    @FieldDoc(required=false, defaultValue="0", help="The number of replicas of the index")
    private int indexNumberOfReplicas = 0;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The username used by the connector to connect to the elastic search cluster. If username is set, a password should also be provided.")
    private String username;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The password used by the connector to connect to the elastic search cluster. If password is set, a username should also be provided")
    private String password;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The token used by the connector to connect to the ElasticSearch cluster. Only one between basic/token/apiKey authentication mode must be configured.")
    private String token;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The apiKey used by the connector to connect to the ElasticSearch cluster. Only one between basic/token/apiKey authentication mode must be configured.")
    private String apiKey;
    @FieldDoc(required=false, defaultValue="1", help="The maximum number of retries for elasticsearch requests. Use -1 to disable it.")
    private int maxRetries = 1;
    @FieldDoc(required=false, defaultValue="100", help="The base time in milliseconds to wait when retrying an elasticsearch request.")
    private long retryBackoffInMs = 100L;
    @FieldDoc(required=false, defaultValue="86400", help="The maximum retry time interval in seconds for retrying an elasticsearch request.")
    private long maxRetryTimeInSec = 86400L;
    @FieldDoc(required=false, defaultValue="false", help="Enable the elasticsearch bulk processor to flush write requests based on the number or size of requests, or after a given period.")
    private boolean bulkEnabled = false;
    @FieldDoc(required=false, defaultValue="1000", help="The maximum number of actions per elasticsearch bulk request. Use -1 to disable it.")
    private int bulkActions = 1000;
    @FieldDoc(required=false, defaultValue="5", help="The maximum size in megabytes of elasticsearch bulk requests.Use -1 to disable it.")
    private long bulkSizeInMb = 5L;
    @FieldDoc(required=false, defaultValue="0", help="The maximum number of in flight elasticsearch bulk requests. The default 0 allows the execution of a single request. A value of 1 means 1 concurrent request is allowed to be executed while accumulating new bulk requests.")
    private int bulkConcurrentRequests = 0;
    @FieldDoc(required=false, defaultValue="1000", help="The bulk flush interval flushing any bulk request pending if the interval passes. -1 or zero means the scheduled flushing is disabled.")
    private long bulkFlushIntervalInMs = 1000L;
    @FieldDoc(required=false, defaultValue="false", help="Enable elasticsearch request compression.")
    private boolean compressionEnabled = false;
    @FieldDoc(required=false, defaultValue="5000", help="The elasticsearch client connection timeout in milliseconds.")
    private int connectTimeoutInMs = 5000;
    @FieldDoc(required=false, defaultValue="1000", help="The time in milliseconds for getting a connection from the elasticsearch connection pool.")
    private int connectionRequestTimeoutInMs = 1000;
    @FieldDoc(required=false, defaultValue="30000", help="Idle connection timeout to prevent a connection timeout due to inactivity.")
    private int connectionIdleTimeoutInMs = 30000;
    @FieldDoc(required=false, defaultValue="60000", help="The socket timeout in milliseconds waiting to read the elasticsearch response.")
    private int socketTimeoutInMs = 60000;
    @FieldDoc(required=false, defaultValue="true", help="Whether to ignore the record key to build the Elasticsearch document _id. If primaryFields is defined, the connector extract the primary fields from the payload to build the document _id. If no primaryFields are provided, elasticsearch auto generates a random document _id.")
    private boolean keyIgnore = true;
    @FieldDoc(required=false, defaultValue="", help="The comma separated ordered list of field names used to build the Elasticsearch document _id from the record value. If this list is a singleton, the field is converted as a string. If this list has 2 or more fields, the generated _id is a string representation of a JSON array of the field values.")
    private String primaryFields = "";
    @FieldDoc(required=false, defaultValue="", help="The SSL config for elastic search.")
    private ElasticSearchSslConfig ssl = new ElasticSearchSslConfig();
    @FieldDoc(required=false, defaultValue="IGNORE", help="How to handle records with null values, possible options are IGNORE, DELETE or FAIL. Default is IGNORE the message.")
    private NullValueAction nullValueAction = NullValueAction.IGNORE;
    @FieldDoc(required=false, defaultValue="FAIL", help="How to handle elasticsearch rejected documents due to some malformation. Possible options are IGNORE, DELETE or FAIL. Default is FAIL the Elasticsearch document.")
    private MalformedDocAction malformedDocAction = MalformedDocAction.FAIL;
    @FieldDoc(required=false, defaultValue="true", help="If stripNulls is false, elasticsearch _source includes 'null' for empty fields (for example {\"foo\": null}), otherwise null fields are stripped.")
    private boolean stripNulls = true;
    @FieldDoc(required=false, defaultValue="AUTO", help="Specify compatibility mode with the ElasticSearch cluster. 'AUTO' value will try to auto detect the correct compatibility mode to use. Use 'ELASTICSEARCH_7' if the target cluster is running ElasticSearch 7 or prior. Use 'ELASTICSEARCH' if the target cluster is running ElasticSearch 8 or higher. Use 'OPENSEARCH' if the target cluster is running OpenSearch.")
    private CompatibilityMode compatibilityMode = CompatibilityMode.AUTO;
    @FieldDoc(defaultValue="false", help="If canonicalKeyFields is true and record key schema is JSON or AVRO, the serialized object will not consider the properties order.")
    private boolean canonicalKeyFields = false;
    @FieldDoc(defaultValue="true", help="If stripNonPrintableCharacters is true, all non-printable characters will be removed from the document.")
    private boolean stripNonPrintableCharacters = true;
    @FieldDoc(defaultValue="NONE", help="Hashing algorithm to use for the document id. This is useful in order to be compliant with the ElasticSearch _id hard limit of 512 bytes.")
    private IdHashingAlgorithm idHashingAlgorithm = IdHashingAlgorithm.NONE;
    @FieldDoc(defaultValue="false", help="This option only works if idHashingAlgorithm is set.If enabled, the hashing is performed only if the id is greater than 512 bytes otherwise the hashing is performed on each document in any case.")
    private boolean conditionalIdHashing = false;
    @FieldDoc(defaultValue="false", help="When the message key schema is AVRO or JSON, copy the message key fields into the Elasticsearch _source.")
    private boolean copyKeyFields = false;

    public static ElasticSearchConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (ElasticSearchConfig)mapper.readValue(new File(yamlFile), ElasticSearchConfig.class);
    }

    public static ElasticSearchConfig load(Map<String, Object> map, SinkContext sinkContext) throws IOException {
        return (ElasticSearchConfig)IOConfigUtils.loadWithSecrets(map, ElasticSearchConfig.class, (SinkContext)sinkContext);
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.elasticSearchUrl)) {
            throw new IllegalArgumentException("elasticSearchUrl not set.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.indexName) && this.createIndexIfNeeded) {
            IndexNameFormatter.validate(this.indexName);
            if (this.indexName.startsWith("-") || this.indexName.startsWith("_") || this.indexName.startsWith("+")) {
                throw new IllegalArgumentException("indexName start with an invalid character.");
            }
            if (this.indexName.equals(".") || this.indexName.equals("..")) {
                throw new IllegalArgumentException("indexName cannot be . or ..");
            }
            if (this.indexName.getBytes(StandardCharsets.UTF_8).length > 255) {
                throw new IllegalArgumentException("indexName cannot be longer than 255 bytes.");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isEmpty((CharSequence)this.password) || StringUtils.isEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password)) {
            throw new IllegalArgumentException("Values for both Username & password are required.");
        }
        boolean basicAuthSet = StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password);
        boolean tokenAuthSet = StringUtils.isNotEmpty((CharSequence)this.token);
        boolean apiKeySet = StringUtils.isNotEmpty((CharSequence)this.apiKey);
        if (basicAuthSet && tokenAuthSet && apiKeySet || basicAuthSet && tokenAuthSet || basicAuthSet && apiKeySet || tokenAuthSet && apiKeySet) {
            throw new IllegalArgumentException("Only one between basic/token/apiKey authentication mode must be configured.");
        }
        if (this.indexNumberOfShards <= 0) {
            throw new IllegalArgumentException("indexNumberOfShards must be a strictly positive integer.");
        }
        if (this.indexNumberOfReplicas < 0) {
            throw new IllegalArgumentException("indexNumberOfReplicas must be a positive integer.");
        }
        if (this.connectTimeoutInMs < 0) {
            throw new IllegalArgumentException("connectTimeoutInMs must be a positive integer.");
        }
        if (this.connectionRequestTimeoutInMs < 0) {
            throw new IllegalArgumentException("connectionRequestTimeoutInMs must be a positive integer.");
        }
        if (this.socketTimeoutInMs < 0) {
            throw new IllegalArgumentException("socketTimeoutInMs must be a positive integer.");
        }
        if (this.bulkConcurrentRequests < 0) {
            throw new IllegalArgumentException("bulkConcurrentRequests must be a positive integer.");
        }
    }

    public String getElasticSearchUrl() {
        return this.elasticSearchUrl;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isSchemaEnable() {
        return this.schemaEnable;
    }

    public int getIndexNumberOfShards() {
        return this.indexNumberOfShards;
    }

    public boolean isCreateIndexIfNeeded() {
        return this.createIndexIfNeeded;
    }

    public int getIndexNumberOfReplicas() {
        return this.indexNumberOfReplicas;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getRetryBackoffInMs() {
        return this.retryBackoffInMs;
    }

    public long getMaxRetryTimeInSec() {
        return this.maxRetryTimeInSec;
    }

    public boolean isBulkEnabled() {
        return this.bulkEnabled;
    }

    public int getBulkActions() {
        return this.bulkActions;
    }

    public long getBulkSizeInMb() {
        return this.bulkSizeInMb;
    }

    public int getBulkConcurrentRequests() {
        return this.bulkConcurrentRequests;
    }

    public long getBulkFlushIntervalInMs() {
        return this.bulkFlushIntervalInMs;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public int getConnectTimeoutInMs() {
        return this.connectTimeoutInMs;
    }

    public int getConnectionRequestTimeoutInMs() {
        return this.connectionRequestTimeoutInMs;
    }

    public int getConnectionIdleTimeoutInMs() {
        return this.connectionIdleTimeoutInMs;
    }

    public int getSocketTimeoutInMs() {
        return this.socketTimeoutInMs;
    }

    public boolean isKeyIgnore() {
        return this.keyIgnore;
    }

    public String getPrimaryFields() {
        return this.primaryFields;
    }

    public ElasticSearchSslConfig getSsl() {
        return this.ssl;
    }

    public NullValueAction getNullValueAction() {
        return this.nullValueAction;
    }

    public MalformedDocAction getMalformedDocAction() {
        return this.malformedDocAction;
    }

    public boolean isStripNulls() {
        return this.stripNulls;
    }

    public CompatibilityMode getCompatibilityMode() {
        return this.compatibilityMode;
    }

    public boolean isCanonicalKeyFields() {
        return this.canonicalKeyFields;
    }

    public boolean isStripNonPrintableCharacters() {
        return this.stripNonPrintableCharacters;
    }

    public IdHashingAlgorithm getIdHashingAlgorithm() {
        return this.idHashingAlgorithm;
    }

    public boolean isConditionalIdHashing() {
        return this.conditionalIdHashing;
    }

    public boolean isCopyKeyFields() {
        return this.copyKeyFields;
    }

    public ElasticSearchConfig setElasticSearchUrl(String elasticSearchUrl) {
        this.elasticSearchUrl = elasticSearchUrl;
        return this;
    }

    public ElasticSearchConfig setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ElasticSearchConfig setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public ElasticSearchConfig setSchemaEnable(boolean schemaEnable) {
        this.schemaEnable = schemaEnable;
        return this;
    }

    public ElasticSearchConfig setIndexNumberOfShards(int indexNumberOfShards) {
        this.indexNumberOfShards = indexNumberOfShards;
        return this;
    }

    public ElasticSearchConfig setCreateIndexIfNeeded(boolean createIndexIfNeeded) {
        this.createIndexIfNeeded = createIndexIfNeeded;
        return this;
    }

    public ElasticSearchConfig setIndexNumberOfReplicas(int indexNumberOfReplicas) {
        this.indexNumberOfReplicas = indexNumberOfReplicas;
        return this;
    }

    public ElasticSearchConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public ElasticSearchConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public ElasticSearchConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public ElasticSearchConfig setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ElasticSearchConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public ElasticSearchConfig setRetryBackoffInMs(long retryBackoffInMs) {
        this.retryBackoffInMs = retryBackoffInMs;
        return this;
    }

    public ElasticSearchConfig setMaxRetryTimeInSec(long maxRetryTimeInSec) {
        this.maxRetryTimeInSec = maxRetryTimeInSec;
        return this;
    }

    public ElasticSearchConfig setBulkEnabled(boolean bulkEnabled) {
        this.bulkEnabled = bulkEnabled;
        return this;
    }

    public ElasticSearchConfig setBulkActions(int bulkActions) {
        this.bulkActions = bulkActions;
        return this;
    }

    public ElasticSearchConfig setBulkSizeInMb(long bulkSizeInMb) {
        this.bulkSizeInMb = bulkSizeInMb;
        return this;
    }

    public ElasticSearchConfig setBulkConcurrentRequests(int bulkConcurrentRequests) {
        this.bulkConcurrentRequests = bulkConcurrentRequests;
        return this;
    }

    public ElasticSearchConfig setBulkFlushIntervalInMs(long bulkFlushIntervalInMs) {
        this.bulkFlushIntervalInMs = bulkFlushIntervalInMs;
        return this;
    }

    public ElasticSearchConfig setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public ElasticSearchConfig setConnectTimeoutInMs(int connectTimeoutInMs) {
        this.connectTimeoutInMs = connectTimeoutInMs;
        return this;
    }

    public ElasticSearchConfig setConnectionRequestTimeoutInMs(int connectionRequestTimeoutInMs) {
        this.connectionRequestTimeoutInMs = connectionRequestTimeoutInMs;
        return this;
    }

    public ElasticSearchConfig setConnectionIdleTimeoutInMs(int connectionIdleTimeoutInMs) {
        this.connectionIdleTimeoutInMs = connectionIdleTimeoutInMs;
        return this;
    }

    public ElasticSearchConfig setSocketTimeoutInMs(int socketTimeoutInMs) {
        this.socketTimeoutInMs = socketTimeoutInMs;
        return this;
    }

    public ElasticSearchConfig setKeyIgnore(boolean keyIgnore) {
        this.keyIgnore = keyIgnore;
        return this;
    }

    public ElasticSearchConfig setPrimaryFields(String primaryFields) {
        this.primaryFields = primaryFields;
        return this;
    }

    public ElasticSearchConfig setSsl(ElasticSearchSslConfig ssl) {
        this.ssl = ssl;
        return this;
    }

    public ElasticSearchConfig setNullValueAction(NullValueAction nullValueAction) {
        this.nullValueAction = nullValueAction;
        return this;
    }

    public ElasticSearchConfig setMalformedDocAction(MalformedDocAction malformedDocAction) {
        this.malformedDocAction = malformedDocAction;
        return this;
    }

    public ElasticSearchConfig setStripNulls(boolean stripNulls) {
        this.stripNulls = stripNulls;
        return this;
    }

    public ElasticSearchConfig setCompatibilityMode(CompatibilityMode compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
        return this;
    }

    public ElasticSearchConfig setCanonicalKeyFields(boolean canonicalKeyFields) {
        this.canonicalKeyFields = canonicalKeyFields;
        return this;
    }

    public ElasticSearchConfig setStripNonPrintableCharacters(boolean stripNonPrintableCharacters) {
        this.stripNonPrintableCharacters = stripNonPrintableCharacters;
        return this;
    }

    public ElasticSearchConfig setIdHashingAlgorithm(IdHashingAlgorithm idHashingAlgorithm) {
        this.idHashingAlgorithm = idHashingAlgorithm;
        return this;
    }

    public ElasticSearchConfig setConditionalIdHashing(boolean conditionalIdHashing) {
        this.conditionalIdHashing = conditionalIdHashing;
        return this;
    }

    public ElasticSearchConfig setCopyKeyFields(boolean copyKeyFields) {
        this.copyKeyFields = copyKeyFields;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchConfig)) {
            return false;
        }
        ElasticSearchConfig other = (ElasticSearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSchemaEnable() != other.isSchemaEnable()) {
            return false;
        }
        if (this.getIndexNumberOfShards() != other.getIndexNumberOfShards()) {
            return false;
        }
        if (this.isCreateIndexIfNeeded() != other.isCreateIndexIfNeeded()) {
            return false;
        }
        if (this.getIndexNumberOfReplicas() != other.getIndexNumberOfReplicas()) {
            return false;
        }
        if (this.getMaxRetries() != other.getMaxRetries()) {
            return false;
        }
        if (this.getRetryBackoffInMs() != other.getRetryBackoffInMs()) {
            return false;
        }
        if (this.getMaxRetryTimeInSec() != other.getMaxRetryTimeInSec()) {
            return false;
        }
        if (this.isBulkEnabled() != other.isBulkEnabled()) {
            return false;
        }
        if (this.getBulkActions() != other.getBulkActions()) {
            return false;
        }
        if (this.getBulkSizeInMb() != other.getBulkSizeInMb()) {
            return false;
        }
        if (this.getBulkConcurrentRequests() != other.getBulkConcurrentRequests()) {
            return false;
        }
        if (this.getBulkFlushIntervalInMs() != other.getBulkFlushIntervalInMs()) {
            return false;
        }
        if (this.isCompressionEnabled() != other.isCompressionEnabled()) {
            return false;
        }
        if (this.getConnectTimeoutInMs() != other.getConnectTimeoutInMs()) {
            return false;
        }
        if (this.getConnectionRequestTimeoutInMs() != other.getConnectionRequestTimeoutInMs()) {
            return false;
        }
        if (this.getConnectionIdleTimeoutInMs() != other.getConnectionIdleTimeoutInMs()) {
            return false;
        }
        if (this.getSocketTimeoutInMs() != other.getSocketTimeoutInMs()) {
            return false;
        }
        if (this.isKeyIgnore() != other.isKeyIgnore()) {
            return false;
        }
        if (this.isStripNulls() != other.isStripNulls()) {
            return false;
        }
        if (this.isCanonicalKeyFields() != other.isCanonicalKeyFields()) {
            return false;
        }
        if (this.isStripNonPrintableCharacters() != other.isStripNonPrintableCharacters()) {
            return false;
        }
        if (this.isConditionalIdHashing() != other.isConditionalIdHashing()) {
            return false;
        }
        if (this.isCopyKeyFields() != other.isCopyKeyFields()) {
            return false;
        }
        String this$elasticSearchUrl = this.getElasticSearchUrl();
        String other$elasticSearchUrl = other.getElasticSearchUrl();
        if (this$elasticSearchUrl == null ? other$elasticSearchUrl != null : !this$elasticSearchUrl.equals(other$elasticSearchUrl)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$primaryFields = this.getPrimaryFields();
        String other$primaryFields = other.getPrimaryFields();
        if (this$primaryFields == null ? other$primaryFields != null : !this$primaryFields.equals(other$primaryFields)) {
            return false;
        }
        ElasticSearchSslConfig this$ssl = this.getSsl();
        ElasticSearchSslConfig other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        NullValueAction this$nullValueAction = this.getNullValueAction();
        NullValueAction other$nullValueAction = other.getNullValueAction();
        if (this$nullValueAction == null ? other$nullValueAction != null : !((Object)((Object)this$nullValueAction)).equals((Object)other$nullValueAction)) {
            return false;
        }
        MalformedDocAction this$malformedDocAction = this.getMalformedDocAction();
        MalformedDocAction other$malformedDocAction = other.getMalformedDocAction();
        if (this$malformedDocAction == null ? other$malformedDocAction != null : !((Object)((Object)this$malformedDocAction)).equals((Object)other$malformedDocAction)) {
            return false;
        }
        CompatibilityMode this$compatibilityMode = this.getCompatibilityMode();
        CompatibilityMode other$compatibilityMode = other.getCompatibilityMode();
        if (this$compatibilityMode == null ? other$compatibilityMode != null : !((Object)((Object)this$compatibilityMode)).equals((Object)other$compatibilityMode)) {
            return false;
        }
        IdHashingAlgorithm this$idHashingAlgorithm = this.getIdHashingAlgorithm();
        IdHashingAlgorithm other$idHashingAlgorithm = other.getIdHashingAlgorithm();
        return !(this$idHashingAlgorithm == null ? other$idHashingAlgorithm != null : !((Object)((Object)this$idHashingAlgorithm)).equals((Object)other$idHashingAlgorithm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSchemaEnable() ? 79 : 97);
        result = result * 59 + this.getIndexNumberOfShards();
        result = result * 59 + (this.isCreateIndexIfNeeded() ? 79 : 97);
        result = result * 59 + this.getIndexNumberOfReplicas();
        result = result * 59 + this.getMaxRetries();
        long $retryBackoffInMs = this.getRetryBackoffInMs();
        result = result * 59 + (int)($retryBackoffInMs >>> 32 ^ $retryBackoffInMs);
        long $maxRetryTimeInSec = this.getMaxRetryTimeInSec();
        result = result * 59 + (int)($maxRetryTimeInSec >>> 32 ^ $maxRetryTimeInSec);
        result = result * 59 + (this.isBulkEnabled() ? 79 : 97);
        result = result * 59 + this.getBulkActions();
        long $bulkSizeInMb = this.getBulkSizeInMb();
        result = result * 59 + (int)($bulkSizeInMb >>> 32 ^ $bulkSizeInMb);
        result = result * 59 + this.getBulkConcurrentRequests();
        long $bulkFlushIntervalInMs = this.getBulkFlushIntervalInMs();
        result = result * 59 + (int)($bulkFlushIntervalInMs >>> 32 ^ $bulkFlushIntervalInMs);
        result = result * 59 + (this.isCompressionEnabled() ? 79 : 97);
        result = result * 59 + this.getConnectTimeoutInMs();
        result = result * 59 + this.getConnectionRequestTimeoutInMs();
        result = result * 59 + this.getConnectionIdleTimeoutInMs();
        result = result * 59 + this.getSocketTimeoutInMs();
        result = result * 59 + (this.isKeyIgnore() ? 79 : 97);
        result = result * 59 + (this.isStripNulls() ? 79 : 97);
        result = result * 59 + (this.isCanonicalKeyFields() ? 79 : 97);
        result = result * 59 + (this.isStripNonPrintableCharacters() ? 79 : 97);
        result = result * 59 + (this.isConditionalIdHashing() ? 79 : 97);
        result = result * 59 + (this.isCopyKeyFields() ? 79 : 97);
        String $elasticSearchUrl = this.getElasticSearchUrl();
        result = result * 59 + ($elasticSearchUrl == null ? 43 : $elasticSearchUrl.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $primaryFields = this.getPrimaryFields();
        result = result * 59 + ($primaryFields == null ? 43 : $primaryFields.hashCode());
        ElasticSearchSslConfig $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        NullValueAction $nullValueAction = this.getNullValueAction();
        result = result * 59 + ($nullValueAction == null ? 43 : ((Object)((Object)$nullValueAction)).hashCode());
        MalformedDocAction $malformedDocAction = this.getMalformedDocAction();
        result = result * 59 + ($malformedDocAction == null ? 43 : ((Object)((Object)$malformedDocAction)).hashCode());
        CompatibilityMode $compatibilityMode = this.getCompatibilityMode();
        result = result * 59 + ($compatibilityMode == null ? 43 : ((Object)((Object)$compatibilityMode)).hashCode());
        IdHashingAlgorithm $idHashingAlgorithm = this.getIdHashingAlgorithm();
        result = result * 59 + ($idHashingAlgorithm == null ? 43 : ((Object)((Object)$idHashingAlgorithm)).hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSearchConfig(elasticSearchUrl=" + this.getElasticSearchUrl() + ", indexName=" + this.getIndexName() + ", typeName=" + this.getTypeName() + ", schemaEnable=" + this.isSchemaEnable() + ", indexNumberOfShards=" + this.getIndexNumberOfShards() + ", createIndexIfNeeded=" + this.isCreateIndexIfNeeded() + ", indexNumberOfReplicas=" + this.getIndexNumberOfReplicas() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", token=" + this.getToken() + ", apiKey=" + this.getApiKey() + ", maxRetries=" + this.getMaxRetries() + ", retryBackoffInMs=" + this.getRetryBackoffInMs() + ", maxRetryTimeInSec=" + this.getMaxRetryTimeInSec() + ", bulkEnabled=" + this.isBulkEnabled() + ", bulkActions=" + this.getBulkActions() + ", bulkSizeInMb=" + this.getBulkSizeInMb() + ", bulkConcurrentRequests=" + this.getBulkConcurrentRequests() + ", bulkFlushIntervalInMs=" + this.getBulkFlushIntervalInMs() + ", compressionEnabled=" + this.isCompressionEnabled() + ", connectTimeoutInMs=" + this.getConnectTimeoutInMs() + ", connectionRequestTimeoutInMs=" + this.getConnectionRequestTimeoutInMs() + ", connectionIdleTimeoutInMs=" + this.getConnectionIdleTimeoutInMs() + ", socketTimeoutInMs=" + this.getSocketTimeoutInMs() + ", keyIgnore=" + this.isKeyIgnore() + ", primaryFields=" + this.getPrimaryFields() + ", ssl=" + this.getSsl() + ", nullValueAction=" + this.getNullValueAction() + ", malformedDocAction=" + this.getMalformedDocAction() + ", stripNulls=" + this.isStripNulls() + ", compatibilityMode=" + this.getCompatibilityMode() + ", canonicalKeyFields=" + this.isCanonicalKeyFields() + ", stripNonPrintableCharacters=" + this.isStripNonPrintableCharacters() + ", idHashingAlgorithm=" + this.getIdHashingAlgorithm() + ", conditionalIdHashing=" + this.isConditionalIdHashing() + ", copyKeyFields=" + this.isCopyKeyFields() + ")";
    }

    public static enum NullValueAction {
        IGNORE,
        DELETE,
        FAIL;

    }

    public static enum MalformedDocAction {
        IGNORE,
        WARN,
        FAIL;

    }

    public static enum CompatibilityMode {
        AUTO,
        ELASTICSEARCH_7,
        ELASTICSEARCH,
        OPENSEARCH;

    }

    public static enum IdHashingAlgorithm {
        NONE,
        SHA256,
        SHA512;

    }
}

