/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.client.api.schema.GenericObject;
import org.apache.pulsar.functions.api.Record;

public class IndexNameFormatter {
    private static final Pattern PATTERN_FIELD_REF = Pattern.compile("%\\{\\+(.+?)}");
    private final String indexNameFormat;
    private final List<String> segments;
    private final List<DateTimeFormatter> dateTimeFormatters;

    public IndexNameFormatter(String indexNameFormat) {
        this.indexNameFormat = indexNameFormat;
        Pair<List<String>, List<DateTimeFormatter>> parsed = IndexNameFormatter.parseFormat(indexNameFormat);
        this.segments = (List)parsed.getKey();
        this.dateTimeFormatters = (List)parsed.getRight();
    }

    static Pair<List<String>, List<DateTimeFormatter>> parseFormat(String format) {
        ArrayList<String> segments = new ArrayList<String>();
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        Matcher matcher = PATTERN_FIELD_REF.matcher(format);
        int pos = 0;
        while (matcher.find()) {
            segments.add(format.substring(pos, matcher.start()));
            formatters.add(DateTimeFormatter.ofPattern(matcher.group(1)).withLocale(Locale.ENGLISH).withZone(ZoneId.of("UTC")));
            pos = matcher.end();
        }
        segments.add(format.substring(pos));
        return Pair.of(segments, formatters);
    }

    static void validate(String format) {
        Pair<List<String>, List<DateTimeFormatter>> parsed = IndexNameFormatter.parseFormat(format);
        for (String s : (List)parsed.getLeft()) {
            if (s.toLowerCase(Locale.ROOT).equals(s)) continue;
            throw new IllegalArgumentException("indexName should be lowercase only.");
        }
    }

    public String indexName(Record<GenericObject> record) {
        if (this.dateTimeFormatters.isEmpty()) {
            return this.indexNameFormat;
        }
        Instant eventTime = Instant.ofEpochMilli((Long)record.getEventTime().orElseThrow(() -> new IllegalStateException("No event time in record")));
        StringBuilder builder = new StringBuilder(this.segments.get(0));
        for (int i = 0; i < this.dateTimeFormatters.size(); ++i) {
            builder.append(this.dateTimeFormatters.get(i).format(eventTime));
            builder.append(this.segments.get(i + 1));
        }
        return builder.toString();
    }
}

