/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch.client.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.apache.pulsar.io.elasticsearch.ElasticSearchConfig;
import org.apache.pulsar.io.elasticsearch.client.BulkProcessor;
import org.apache.pulsar.io.elasticsearch.client.RestClient;
import org.apache.pulsar.io.elasticsearch.client.elastic.ElasticBulkProcessor;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchJavaRestClient
extends RestClient {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchJavaRestClient.class);
    private final ElasticsearchClient client;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, false).setSerializationInclusion(JsonInclude.Include.ALWAYS);
    private BulkProcessor bulkProcessor;
    private ElasticsearchTransport transport;

    @VisibleForTesting
    public void setBulkProcessor(BulkProcessor bulkProcessor) {
        this.bulkProcessor = bulkProcessor;
    }

    @VisibleForTesting
    public void setTransport(ElasticsearchTransport transport) {
        this.transport = transport;
    }

    public ElasticSearchJavaRestClient(ElasticSearchConfig elasticSearchConfig, BulkProcessor.Listener bulkProcessorListener) {
        super(elasticSearchConfig, bulkProcessorListener);
        log.info("ElasticSearch URL {}", (Object)this.config.getElasticSearchUrl());
        HttpHost[] httpHosts = this.getHttpHosts();
        RestClientBuilder builder = org.elasticsearch.client.RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(builder1 -> builder1.setContentCompressionEnabled(this.config.isCompressionEnabled()).setConnectionRequestTimeout(this.config.getConnectionRequestTimeoutInMs()).setConnectTimeout(this.config.getConnectTimeoutInMs()).setSocketTimeout(this.config.getSocketTimeoutInMs())).setCompressionEnabled(this.config.isCompressionEnabled()).setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)this.configCallback).setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                log.warn("Node host={} failed", (Object)node.getHost());
            }
        });
        this.transport = new RestClientTransport(builder.build(), (JsonpMapper)new JacksonJsonpMapper(this.objectMapper));
        this.client = new ElasticsearchClient(this.transport);
        this.bulkProcessor = elasticSearchConfig.isBulkEnabled() ? new ElasticBulkProcessor(elasticSearchConfig, this.client, bulkProcessorListener) : null;
    }

    @Override
    public boolean indexExists(String index) throws IOException {
        ExistsRequest request = new ExistsRequest.Builder().index(index, new String[0]).build();
        return this.client.indices().exists(request).value();
    }

    @Override
    public boolean createIndex(String index) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index(index).settings(new IndexSettings.Builder().numberOfShards("" + this.config.getIndexNumberOfShards()).numberOfReplicas("" + this.config.getIndexNumberOfReplicas()).build()).build();
        try {
            CreateIndexResponse createIndexResponse = this.client.indices().create(createIndexRequest);
            if (createIndexResponse.acknowledged() && createIndexResponse.shardsAcknowledged()) {
                return true;
            }
            throw new IOException("Unable to create index, acknowledged: " + createIndexResponse.acknowledged() + " shardsAcknowledged: " + createIndexResponse.shardsAcknowledged());
        }
        catch (ElasticsearchException ex) {
            String errorType = Objects.requireNonNull(ex.response().error().type());
            if (errorType.contains("resource_already_exists_exception")) {
                return false;
            }
            throw ex;
        }
    }

    @Override
    public boolean deleteIndex(String index) throws IOException {
        return this.client.indices().delete(new DeleteIndexRequest.Builder().index(index, new String[0]).build()).acknowledged();
    }

    @Override
    public boolean deleteDocument(String index, String documentId) throws IOException {
        DeleteRequest req = new DeleteRequest.Builder().index(index).id(documentId).build();
        DeleteResponse deleteResponse = this.client.delete(req);
        return deleteResponse.result().equals((Object)Result.Deleted) || deleteResponse.result().equals((Object)Result.NotFound);
    }

    @Override
    public boolean indexDocument(String index, String documentId, String documentSource) throws IOException {
        Map mapped = (Map)this.objectMapper.readValue(documentSource, Map.class);
        IndexRequest indexRequest = new IndexRequest.Builder().index(index).document((Object)mapped).id(documentId).build();
        IndexResponse indexResponse = this.client.index(indexRequest);
        return indexResponse.result().equals((Object)Result.Created) || indexResponse.result().equals((Object)Result.Updated);
    }

    public SearchResponse<Map> search(String indexName) throws IOException {
        return this.search(indexName, "*:*");
    }

    @VisibleForTesting
    public SearchResponse<Map> search(String indexName, String query) throws IOException {
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(indexName, new String[0]).build();
        this.client.indices().refresh(refreshRequest);
        query = query.replace("/", "\\/");
        return this.client.search(new SearchRequest.Builder().index(indexName, new String[0]).q(query).build(), Map.class);
    }

    @Override
    public long totalHits(String indexName) throws IOException {
        return this.totalHits(indexName, "*:*");
    }

    @Override
    public long totalHits(String indexName, String query) throws IOException {
        SearchResponse<Map> searchResponse = this.search(indexName, query);
        return searchResponse.hits().total().value();
    }

    @Override
    public BulkProcessor getBulkProcessor() {
        if (this.bulkProcessor == null) {
            throw new IllegalStateException("bulkProcessor not enabled");
        }
        return this.bulkProcessor;
    }

    @Override
    public void closeClient() {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.close();
        }
        try {
            this.transport.close();
        }
        catch (IOException e) {
            log.warn("error while closing the client", (Throwable)e);
        }
    }

    @VisibleForTesting
    public ElasticsearchClient getClient() {
        return this.client;
    }

    @VisibleForTesting
    public ElasticsearchTransport getTransport() {
        return this.transport;
    }
}

