/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.io.kafka.connect.schema.PulsarSchemaToKafkaSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConnectData {
    private static final Logger log = LoggerFactory.getLogger(KafkaConnectData.class);

    private static List<Object> arrayToList(Object nativeObject, Schema kafkaValueSchema) {
        Preconditions.checkArgument((boolean)nativeObject.getClass().isArray());
        int length = Array.getLength(nativeObject);
        ArrayList<Object> out = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object elem = Array.get(nativeObject, i);
            out.add(KafkaConnectData.getKafkaConnectData(elem, kafkaValueSchema));
        }
        return out;
    }

    public static Object getKafkaConnectDataFromSchema(Object nativeObject, Schema kafkaSchema) {
        if (kafkaSchema != null && nativeObject == null) {
            return null;
        }
        return KafkaConnectData.getKafkaConnectData(nativeObject, kafkaSchema);
    }

    public static Object getKafkaConnectData(Object nativeObject, Schema kafkaSchema) {
        if (kafkaSchema == null) {
            return nativeObject;
        }
        if (nativeObject == null) {
            return KafkaConnectData.defaultOrThrow(kafkaSchema);
        }
        if (nativeObject instanceof JsonNode) {
            JsonNode node = (JsonNode)nativeObject;
            return KafkaConnectData.jsonAsConnectData(node, kafkaSchema);
        }
        switch (kafkaSchema.type()) {
            case ARRAY: {
                if (nativeObject instanceof List) {
                    List arr = (List)nativeObject;
                    return arr.stream().map(x -> KafkaConnectData.getKafkaConnectData(x, kafkaSchema.valueSchema())).toList();
                }
                if (nativeObject.getClass().isArray()) {
                    return KafkaConnectData.arrayToList(nativeObject, kafkaSchema.valueSchema());
                }
                throw new IllegalStateException("Don't know how to convert " + nativeObject.getClass() + " into kafka ARRAY");
            }
            case MAP: {
                if (nativeObject instanceof Map) {
                    Map map = (Map)nativeObject;
                    HashMap<Object, Object> responseMap = new HashMap<Object, Object>(map.size());
                    for (Map.Entry kv : map.entrySet()) {
                        Object key = KafkaConnectData.getKafkaConnectData(kv.getKey(), kafkaSchema.keySchema());
                        Object val = KafkaConnectData.getKafkaConnectData(kv.getValue(), kafkaSchema.valueSchema());
                        responseMap.put(key, val);
                    }
                    return responseMap;
                }
                if (nativeObject instanceof KeyValue) {
                    KeyValue kv = (KeyValue)nativeObject;
                    HashMap<Object, Object> responseMap = new HashMap<Object, Object>();
                    Object key = KafkaConnectData.getKafkaConnectData(kv.getKey(), kafkaSchema.keySchema());
                    Object val = KafkaConnectData.getKafkaConnectData(kv.getValue(), kafkaSchema.valueSchema());
                    responseMap.put(key, val);
                    return responseMap;
                }
                throw new IllegalStateException("Don't know how to convert " + nativeObject.getClass() + " into kafka MAP");
            }
            case STRUCT: {
                if (nativeObject instanceof GenericData.Record) {
                    GenericData.Record avroRecord = (GenericData.Record)nativeObject;
                    return KafkaConnectData.avroAsConnectData(avroRecord, kafkaSchema);
                }
                if (nativeObject instanceof GenericRecord) {
                    GenericRecord pulsarGenericRecord = (GenericRecord)nativeObject;
                    if (pulsarGenericRecord.getNativeObject() instanceof JsonNode || pulsarGenericRecord.getNativeObject() instanceof GenericData.Record) {
                        return KafkaConnectData.getKafkaConnectData(pulsarGenericRecord.getNativeObject(), kafkaSchema);
                    }
                    return KafkaConnectData.pulsarGenericRecordAsConnectData(pulsarGenericRecord, kafkaSchema);
                }
                throw new IllegalStateException("Don't know how to convert " + nativeObject.getClass() + "into kafka STRUCT");
            }
        }
        Preconditions.checkArgument((boolean)kafkaSchema.type().isPrimitive(), (Object)("Expected primitive schema but got " + kafkaSchema.type()));
        return KafkaConnectData.castToKafkaSchema(nativeObject, kafkaSchema);
    }

    public static Object castToKafkaSchema(Object nativeObject, Schema kafkaSchema) {
        if (PulsarSchemaToKafkaSchema.matchesToKafkaLogicalSchema(kafkaSchema)) {
            if ("org.apache.kafka.connect.data.Timestamp".equals(kafkaSchema.name())) {
                if (nativeObject instanceof Date) {
                    return nativeObject;
                }
                return Timestamp.toLogical((Schema)kafkaSchema, (long)((Number)nativeObject).longValue());
            }
            if ("org.apache.kafka.connect.data.Date".equals(kafkaSchema.name())) {
                if (nativeObject instanceof Date) {
                    return nativeObject;
                }
                return org.apache.kafka.connect.data.Date.toLogical((Schema)kafkaSchema, (int)((Number)nativeObject).intValue());
            }
            if ("org.apache.kafka.connect.data.Time".equals(kafkaSchema.name())) {
                if (nativeObject instanceof Date) {
                    return nativeObject;
                }
                return Time.toLogical((Schema)kafkaSchema, (int)((Number)nativeObject).intValue());
            }
            if ("org.apache.kafka.connect.data.Decimal".equals(kafkaSchema.name())) {
                if (nativeObject instanceof BigDecimal) {
                    return nativeObject;
                }
                return Decimal.toLogical((Schema)kafkaSchema, (byte[])((byte[])nativeObject));
            }
            throw new IllegalStateException("Unsupported Kafka Logical Schema " + kafkaSchema.name() + " for value " + nativeObject);
        }
        if (nativeObject instanceof Number) {
            Number num = (Number)nativeObject;
            switch (kafkaSchema.type()) {
                case INT8: {
                    if (nativeObject instanceof Byte) break;
                    if (log.isDebugEnabled()) {
                        log.debug("nativeObject of type {} converted to Byte", nativeObject.getClass());
                    }
                    return num.byteValue();
                }
                case INT16: {
                    if (nativeObject instanceof Short) break;
                    if (log.isDebugEnabled()) {
                        log.debug("nativeObject of type {} converted to Short", nativeObject.getClass());
                    }
                    return num.shortValue();
                }
                case INT32: {
                    if (nativeObject instanceof Integer) break;
                    if (log.isDebugEnabled()) {
                        log.debug("nativeObject of type {} converted to Integer", nativeObject.getClass());
                    }
                    return num.intValue();
                }
                case INT64: {
                    if (nativeObject instanceof Long) break;
                    if (log.isDebugEnabled()) {
                        log.debug("nativeObject of type {} converted to Long", nativeObject.getClass());
                    }
                    return num.longValue();
                }
                case FLOAT32: {
                    if (nativeObject instanceof Float) break;
                    if (log.isDebugEnabled()) {
                        log.debug("nativeObject of type {} converted to Float", nativeObject.getClass());
                    }
                    return Float.valueOf(num.floatValue());
                }
                case FLOAT64: {
                    if (nativeObject instanceof Double) break;
                    if (log.isDebugEnabled()) {
                        log.debug("nativeObject of type {} converted to Double", nativeObject.getClass());
                    }
                    return num.doubleValue();
                }
            }
        }
        if (nativeObject instanceof Character) {
            Character ch = (Character)nativeObject;
            if (kafkaSchema.type() == Schema.Type.STRING) {
                return ch.toString();
            }
            return KafkaConnectData.castToKafkaSchema(Character.getNumericValue(ch.charValue()), kafkaSchema);
        }
        if (kafkaSchema.type() == Schema.Type.STRING && nativeObject instanceof CharSequence) {
            return nativeObject.toString();
        }
        return nativeObject;
    }

    static Object avroAsConnectData(GenericData.Record avroRecord, Schema kafkaSchema) {
        if (kafkaSchema == null) {
            if (avroRecord == null) {
                return null;
            }
            throw new DataException("Don't know how to convert " + avroRecord + " to Connect data (schema is null).");
        }
        Struct struct = new Struct(kafkaSchema);
        for (Field field : kafkaSchema.fields()) {
            struct.put(field, KafkaConnectData.getKafkaConnectData(avroRecord.get(field.name()), field.schema()));
        }
        return struct;
    }

    static Object pulsarGenericRecordAsConnectData(GenericRecord genericRecord, Schema kafkaSchema) {
        if (kafkaSchema == null) {
            if (genericRecord == null) {
                return null;
            }
            throw new DataException("Don't know how to convert " + genericRecord + " to Connect data (schema is null).");
        }
        Struct struct = new Struct(kafkaSchema);
        for (Field field : kafkaSchema.fields()) {
            struct.put(field, KafkaConnectData.getKafkaConnectData(genericRecord.getField(field.name()), field.schema()));
        }
        return struct;
    }

    static Object jsonAsConnectData(JsonNode jsonNode, Schema kafkaSchema) {
        if (kafkaSchema == null) {
            if (jsonNode == null || jsonNode.isNull()) {
                return null;
            }
            throw new DataException("Don't know how to convert " + jsonNode + " to Connect data (schema is null).");
        }
        if (jsonNode == null || jsonNode.isNull()) {
            return KafkaConnectData.defaultOrThrow(kafkaSchema);
        }
        if (PulsarSchemaToKafkaSchema.matchesToKafkaLogicalSchema(kafkaSchema)) {
            if ("org.apache.kafka.connect.data.Timestamp".equals(kafkaSchema.name())) {
                return Timestamp.toLogical((Schema)kafkaSchema, (long)jsonNode.longValue());
            }
            if ("org.apache.kafka.connect.data.Date".equals(kafkaSchema.name())) {
                return org.apache.kafka.connect.data.Date.toLogical((Schema)kafkaSchema, (int)jsonNode.intValue());
            }
            if ("org.apache.kafka.connect.data.Time".equals(kafkaSchema.name())) {
                return Time.toLogical((Schema)kafkaSchema, (int)jsonNode.intValue());
            }
            if ("org.apache.kafka.connect.data.Decimal".equals(kafkaSchema.name())) {
                if (jsonNode.isNumber()) {
                    return jsonNode.decimalValue();
                }
                try {
                    return Decimal.toLogical((Schema)kafkaSchema, (byte[])jsonNode.binaryValue());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not convert Kafka Logical Schema " + kafkaSchema.name() + " for jsonNode " + jsonNode + " into Decimal");
                }
            }
            throw new IllegalStateException("Unsupported Kafka Logical Schema " + kafkaSchema.name() + " for jsonNode " + jsonNode);
        }
        switch (kafkaSchema.type()) {
            case INT8: {
                Preconditions.checkArgument((boolean)jsonNode.isNumber());
                return (byte)jsonNode.shortValue();
            }
            case INT16: {
                Preconditions.checkArgument((boolean)jsonNode.isNumber());
                return jsonNode.shortValue();
            }
            case INT32: {
                if (jsonNode.isTextual() && jsonNode.textValue().length() == 1) {
                    return Character.getNumericValue(jsonNode.textValue().charAt(0));
                }
                Preconditions.checkArgument((boolean)jsonNode.isNumber());
                return jsonNode.intValue();
            }
            case INT64: {
                Preconditions.checkArgument((boolean)jsonNode.isNumber());
                return jsonNode.longValue();
            }
            case FLOAT32: {
                Preconditions.checkArgument((boolean)jsonNode.isNumber());
                return Float.valueOf(jsonNode.floatValue());
            }
            case FLOAT64: {
                Preconditions.checkArgument((boolean)jsonNode.isNumber());
                return jsonNode.doubleValue();
            }
            case BOOLEAN: {
                Preconditions.checkArgument((boolean)jsonNode.isBoolean());
                return jsonNode.booleanValue();
            }
            case STRING: {
                Preconditions.checkArgument((boolean)jsonNode.isTextual());
                return jsonNode.textValue();
            }
            case BYTES: {
                Preconditions.checkArgument((boolean)jsonNode.isBinary());
                try {
                    return jsonNode.binaryValue();
                }
                catch (IOException e) {
                    throw new DataException("Cannot get binary value for " + jsonNode + " with schema " + kafkaSchema);
                }
            }
            case ARRAY: {
                if (jsonNode.isTextual() && kafkaSchema.valueSchema().type() == Schema.Type.INT32) {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (char ch : jsonNode.textValue().toCharArray()) {
                        list.add(Character.getNumericValue(ch));
                    }
                    return list;
                }
                Preconditions.checkArgument((boolean)jsonNode.isArray(), (Object)"jsonNode has to be an array");
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator it = jsonNode.elements();
                while (it.hasNext()) {
                    list.add(KafkaConnectData.jsonAsConnectData((JsonNode)it.next(), kafkaSchema.valueSchema()));
                }
                return list;
            }
            case MAP: {
                Preconditions.checkArgument((boolean)jsonNode.isObject(), (Object)"jsonNode has to be an Object node");
                Preconditions.checkArgument((kafkaSchema.keySchema().type() == Schema.Type.STRING ? 1 : 0) != 0, (Object)"kafka schema for json map is expected to be STRING");
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator it = jsonNode.fields();
                while (it.hasNext()) {
                    Map.Entry elem = (Map.Entry)it.next();
                    map.put((String)elem.getKey(), KafkaConnectData.jsonAsConnectData((JsonNode)elem.getValue(), kafkaSchema.valueSchema()));
                }
                return map;
            }
            case STRUCT: {
                Struct struct = new Struct(kafkaSchema);
                for (Field field : kafkaSchema.fields()) {
                    struct.put(field, KafkaConnectData.jsonAsConnectData(jsonNode.get(field.name()), field.schema()));
                }
                return struct;
            }
        }
        throw new DataException("Unknown schema type " + kafkaSchema.type());
    }

    private static Object defaultOrThrow(Schema kafkaSchema) {
        if (kafkaSchema.defaultValue() != null) {
            return kafkaSchema.defaultValue();
        }
        if (kafkaSchema.isOptional()) {
            return null;
        }
        throw new DataException("Invalid null value for required " + kafkaSchema.type() + " field");
    }
}

