/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.kafka.KafkaSinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaAbstractSink<K, V>
implements Sink<byte[]> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaAbstractSink.class);
    private Producer<K, V> producer;
    private final Properties props = new Properties();
    private KafkaSinkConfig kafkaSinkConfig;

    public void write(Record<byte[]> sourceRecord) {
        KeyValue<K, V> keyValue = this.extractKeyValue(sourceRecord);
        ProducerRecord record = new ProducerRecord(this.kafkaSinkConfig.getTopic(), keyValue.getKey(), keyValue.getValue());
        if (log.isDebugEnabled()) {
            log.debug("Record sending to kafka, record={}.", (Object)record);
        }
        this.producer.send(record, (metadata, exception) -> {
            if (exception == null) {
                sourceRecord.ack();
            } else {
                sourceRecord.fail();
            }
        });
    }

    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
            log.info("Kafka sink stopped.");
        }
    }

    protected Properties beforeCreateProducer(Properties props) {
        return props;
    }

    public void open(Map<String, Object> config, SinkContext sinkContext) throws Exception {
        this.kafkaSinkConfig = KafkaSinkConfig.load(config, sinkContext);
        if (this.kafkaSinkConfig.getBatchSize() <= 0L) {
            throw new IllegalArgumentException("Invalid Kafka Producer batchSize : " + this.kafkaSinkConfig.getBatchSize());
        }
        if (this.kafkaSinkConfig.getMaxRequestSize() <= 0L) {
            throw new IllegalArgumentException("Invalid Kafka Producer maxRequestSize : " + this.kafkaSinkConfig.getMaxRequestSize());
        }
        if (this.kafkaSinkConfig.getProducerConfigProperties() != null) {
            this.props.putAll(this.kafkaSinkConfig.getProducerConfigProperties());
        }
        this.props.put("bootstrap.servers", this.kafkaSinkConfig.getBootstrapServers());
        if (StringUtils.isNotEmpty((CharSequence)this.kafkaSinkConfig.getSecurityProtocol())) {
            this.props.put("security.protocol", this.kafkaSinkConfig.getSecurityProtocol());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kafkaSinkConfig.getSaslMechanism())) {
            this.props.put("sasl.mechanism", this.kafkaSinkConfig.getSaslMechanism());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kafkaSinkConfig.getSaslJaasConfig())) {
            this.props.put("sasl.jaas.config", this.kafkaSinkConfig.getSaslJaasConfig());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kafkaSinkConfig.getSslEnabledProtocols())) {
            this.props.put("ssl.enabled.protocols", this.kafkaSinkConfig.getSslEnabledProtocols());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kafkaSinkConfig.getSslEndpointIdentificationAlgorithm())) {
            this.props.put("ssl.endpoint.identification.algorithm", this.kafkaSinkConfig.getSslEndpointIdentificationAlgorithm());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kafkaSinkConfig.getSslTruststoreLocation())) {
            this.props.put("ssl.truststore.location", this.kafkaSinkConfig.getSslTruststoreLocation());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.kafkaSinkConfig.getSslTruststorePassword())) {
            this.props.put("ssl.truststore.password", this.kafkaSinkConfig.getSslTruststorePassword());
        }
        this.props.put("acks", this.kafkaSinkConfig.getAcks());
        this.props.put("batch.size", String.valueOf(this.kafkaSinkConfig.getBatchSize()));
        this.props.put("max.request.size", String.valueOf(this.kafkaSinkConfig.getMaxRequestSize()));
        this.props.put("key.serializer", this.kafkaSinkConfig.getKeySerializerClass());
        this.props.put("value.serializer", this.kafkaSinkConfig.getValueSerializerClass());
        this.producer = new KafkaProducer(this.beforeCreateProducer(this.props));
        log.info("Kafka sink started : {}.", (Object)this.props);
    }

    public abstract KeyValue<K, V> extractKeyValue(Record<byte[]> var1);
}

