/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import java.util.Properties;
import lombok.Generated;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.KeyValue;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;
import org.apache.pulsar.io.kafka.KafkaAbstractSink;
import org.apache.pulsar.io.kafka.KafkaSinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Connector(name="kafka", type=IOType.SINK, help="The KafkaBytesSink is used for moving messages from Pulsar to Kafka.", configClass=KafkaSinkConfig.class)
public class KafkaBytesSink
extends KafkaAbstractSink<String, byte[]> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaBytesSink.class);

    @Override
    protected Properties beforeCreateProducer(Properties props) {
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", ByteArraySerializer.class.getName());
        log.info("Created kafka producer config : {}", (Object)props);
        return props;
    }

    @Override
    public KeyValue<String, byte[]> extractKeyValue(Record<byte[]> record) {
        return new KeyValue((Object)record.getKey().orElse(null), (Object)((byte[])record.getValue()));
    }
}

