/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.mongodb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.PushSource;
import org.apache.pulsar.io.core.SourceContext;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;
import org.apache.pulsar.io.mongodb.MongoSourceConfig;
import org.apache.pulsar.io.mongodb.SyncType;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Connector(name="mongo", type=IOType.SOURCE, help="A source connector that sends mongodb documents to pulsar", configClass=MongoSourceConfig.class)
public class MongoSource
extends PushSource<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(MongoSource.class);
    private final Supplier<MongoClient> clientProvider;
    private MongoSourceConfig mongoSourceConfig;
    private MongoClient mongoClient;
    private ChangeStreamPublisher<Document> stream;

    public MongoSource() {
        this(null);
    }

    public MongoSource(Supplier<MongoClient> clientProvider) {
        this.clientProvider = clientProvider;
    }

    public void open(Map<String, Object> config, SourceContext sourceContext) throws Exception {
        log.info("Open MongoDB Source");
        this.mongoSourceConfig = MongoSourceConfig.load(config);
        this.mongoSourceConfig.validate();
        this.mongoClient = this.clientProvider != null ? this.clientProvider.get() : MongoClients.create((String)this.mongoSourceConfig.getMongoUri());
        String mongoDatabase = this.mongoSourceConfig.getDatabase();
        if (StringUtils.isEmpty((CharSequence)mongoDatabase)) {
            log.info("Watch all databases");
            this.stream = this.mongoClient.watch();
        } else {
            MongoDatabase db = this.mongoClient.getDatabase(mongoDatabase);
            String mongoCollection = this.mongoSourceConfig.getCollection();
            if (StringUtils.isEmpty((CharSequence)mongoCollection)) {
                log.info("Watch db: {}", (Object)db.getName());
                this.stream = db.watch();
            } else {
                MongoCollection collection = db.getCollection(mongoCollection);
                log.info("Watch collection: {}.{}", (Object)db.getName(), (Object)mongoCollection);
                this.stream = collection.watch();
            }
        }
        this.stream.batchSize(this.mongoSourceConfig.getBatchSize()).fullDocument(FullDocument.UPDATE_LOOKUP);
        if (this.mongoSourceConfig.getSyncType() == SyncType.FULL_SYNC) {
            this.stream.startAtOperationTime(new BsonTimestamp(0L));
        }
        this.stream.subscribe((Subscriber)new Subscriber<ChangeStreamDocument<Document>>(){
            private ObjectMapper mapper = new ObjectMapper();
            private Subscription subscription;

            public void onSubscribe(Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(Integer.MAX_VALUE);
            }

            public void onNext(ChangeStreamDocument<Document> doc) {
                try {
                    log.info("New change doc: {}", doc);
                    BsonDocument documentKey = doc.getDocumentKey();
                    if (documentKey == null) {
                        log.warn("The document key is null");
                        return;
                    }
                    HashMap<String, Object> recordValue = new HashMap<String, Object>();
                    recordValue.put("fullDocument", doc.getFullDocument());
                    recordValue.put("ns", doc.getNamespace());
                    recordValue.put("operation", doc.getOperationType());
                    MongoSource.this.consume(new DocRecord(Optional.of(documentKey.toJson()), this.mapper.writeValueAsString(recordValue).getBytes(StandardCharsets.UTF_8)));
                }
                catch (JsonProcessingException e) {
                    log.error("Processing doc from mongo", (Throwable)e);
                }
            }

            public void onError(Throwable error) {
                log.error("Subscriber error", error);
            }

            public void onComplete() {
                log.info("Subscriber complete");
            }
        });
    }

    public void close() throws Exception {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    private static class DocRecord
    implements Record<byte[]> {
        private final Optional<String> key;
        private final byte[] value;

        public DocRecord(Optional<String> key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public Optional<String> getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocRecord)) {
                return false;
            }
            DocRecord other = (DocRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<String> this$key = this.getKey();
            Optional<String> other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof DocRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "MongoSource.DocRecord(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }
    }
}

