/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.mongodb.MongoAbstractConfig;

public class MongoSinkConfig
extends MongoAbstractConfig {
    private static final long serialVersionUID = 8805978990904614084L;

    @JsonCreator
    public MongoSinkConfig(@JsonProperty(value="mongoUri") String mongoUri, @JsonProperty(value="database") String database, @JsonProperty(value="collection") String collection, @JsonProperty(value="batchSize") int batchSize, @JsonProperty(value="batchTimeMs") long batchTimeMs) {
        super(mongoUri, database, collection, batchSize, batchTimeMs);
    }

    public static MongoSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        MongoSinkConfig cfg = (MongoSinkConfig)mapper.readValue(new File(yamlFile), MongoSinkConfig.class);
        return cfg;
    }

    public static MongoSinkConfig load(Map<String, Object> map, SinkContext sinkContext) throws IOException {
        return (MongoSinkConfig)IOConfigUtils.loadWithSecrets(map, MongoSinkConfig.class, (SinkContext)sinkContext);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.getDatabase()) ? 1 : 0) != 0, (Object)"Required MongoDB database name is not set.");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.getCollection()) ? 1 : 0) != 0, (Object)"Required MongoDB collection name is not set.");
    }

    @Override
    public String toString() {
        return "MongoSinkConfig()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoSinkConfig)) {
            return false;
        }
        MongoSinkConfig other = (MongoSinkConfig)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MongoSinkConfig;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

