/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStoreProvider;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.apache.qpid.server.store.jdbc.JdbcUtils;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;

public abstract class AbstractJDBCConfigurationStore
implements MessageStoreProvider,
DurableConfigurationStore {
    private static final String CONFIGURATION_VERSION_TABLE_NAME_SUFFIX = "QPID_CONFIG_VERSION";
    private static final String VERSION_1_CONFIGURED_OBJECTS_TABLE_NAME_SUFFIX = "QPID_CONFIGURED_OBJECTS";
    private static final String VERSION_1_CONFIGURED_OBJECT_HIERARCHY_TABLE_NAME_SUFFIX = "QPID_CONFIGURED_OBJECT_HIERARCHY";
    private static final String CONFIGURATION_STRUCTURE_VERSION_TABLE_NAME_SUFFIX = "QPID_CFG_VERSION";
    private static final String CONFIGURED_OBJECTS_TABLE_NAME_SUFFIX = "QPID_CFG_OBJECTS";
    private static final String CONFIGURED_OBJECT_HIERARCHY_TABLE_NAME_SUFFIX = "QPID_CFG_HIERARCHY";
    private static final int CONFIG_DB_VERSION = 2;
    private static final int DEFAULT_CONFIG_VERSION = 0;
    private final Set<Action<Connection>> _deleteActions = Collections.newSetFromMap(new ConcurrentHashMap());
    private State _state = State.CLOSED;
    private final Object _lock = new Object();
    private String _tableNamePrefix = "";

    protected void setTableNamePrefix(String tableNamePrefix) {
        this._tableNamePrefix = tableNamePrefix == null ? "" : tableNamePrefix;
    }

    public boolean openConfigurationStore(ConfiguredObjectRecordHandler handler, ConfiguredObjectRecord ... initialRecords) {
        this.changeState(State.CONFIGURED, State.OPEN);
        this._deleteActions.clear();
        try {
            Collection<ConfiguredObjectRecordImpl> records = this.doVisitAllConfiguredObjectRecords(handler);
            boolean isNew = records.isEmpty();
            if (isNew) {
                records = Arrays.asList(initialRecords);
                try (Connection conn = this.newConnection();){
                    for (ConfiguredObjectRecord configuredObjectRecord : records) {
                        this.updateConfiguredObject(configuredObjectRecord, true, conn);
                    }
                    conn.commit();
                }
                catch (SQLException e) {
                    throw new StoreException("Error updating configured objects in database: " + e.getMessage(), (Throwable)e);
                }
            }
            for (ConfiguredObjectRecord configuredObjectRecord : records) {
                handler.handle(configuredObjectRecord);
            }
            return isNew;
        }
        catch (SQLException e) {
            throw new StoreException("Cannot visit configured object records", (Throwable)e);
        }
    }

    public void reload(ConfiguredObjectRecordHandler handler) throws StoreException {
        this.assertState(State.OPEN);
        try {
            Collection<ConfiguredObjectRecordImpl> records = this.doVisitAllConfiguredObjectRecords(handler);
            for (ConfiguredObjectRecord configuredObjectRecord : records) {
                handler.handle(configuredObjectRecord);
            }
        }
        catch (SQLException e) {
            throw new StoreException("Cannot visit configured object records", (Throwable)e);
        }
    }

    private String getConfigurationVersionTableName() {
        return this._tableNamePrefix + CONFIGURATION_VERSION_TABLE_NAME_SUFFIX;
    }

    String getConfiguredObjectsTableName() {
        return this._tableNamePrefix + CONFIGURED_OBJECTS_TABLE_NAME_SUFFIX;
    }

    String getConfiguredObjectHierarchyTableName() {
        return this._tableNamePrefix + CONFIGURED_OBJECT_HIERARCHY_TABLE_NAME_SUFFIX;
    }

    private String getConfigStructureVersionTableName() {
        return this._tableNamePrefix + CONFIGURATION_STRUCTURE_VERSION_TABLE_NAME_SUFFIX;
    }

    private String getVersion1ConfiguredObjectsTableName() {
        return this._tableNamePrefix + VERSION_1_CONFIGURED_OBJECTS_TABLE_NAME_SUFFIX;
    }

    private String getVersion1ConfiguredObjectHierarchyTableName() {
        return this._tableNamePrefix + VERSION_1_CONFIGURED_OBJECT_HIERARCHY_TABLE_NAME_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ConfiguredObjectRecordImpl> doVisitAllConfiguredObjectRecords(ConfiguredObjectRecordHandler handler) throws SQLException {
        HashMap<UUID, ConfiguredObjectRecordImpl> configuredObjects = new HashMap<UUID, ConfiguredObjectRecordImpl>();
        ObjectMapper objectMapper = new ObjectMapper();
        try (Connection conn = this.newAutoCommitConnection();){
            ResultSet rs;
            try (PreparedStatement stmt = conn.prepareStatement("SELECT id, object_type, attributes FROM " + this.getConfiguredObjectsTableName());){
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String objectType = rs.getString(2);
                        String attributes = this.getBlobAsString(rs, 3);
                        ConfiguredObjectRecordImpl configuredObjectRecord = new ConfiguredObjectRecordImpl(UUID.fromString(id), objectType, (Map)objectMapper.readValue(attributes, Map.class));
                        configuredObjects.put(configuredObjectRecord.getId(), configuredObjectRecord);
                    }
                }
                catch (IOException e) {
                    throw new StoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    rs.close();
                }
            }
            stmt = conn.prepareStatement("SELECT child_id, parent_type, parent_id FROM " + this.getConfiguredObjectHierarchyTableName());
            try {
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        UUID childId = UUID.fromString(rs.getString(1));
                        String parentType = rs.getString(2);
                        UUID parentId = UUID.fromString(rs.getString(3));
                        ConfiguredObjectRecordImpl child = (ConfiguredObjectRecordImpl)configuredObjects.get(childId);
                        ConfiguredObjectRecordImpl parent = (ConfiguredObjectRecordImpl)configuredObjects.get(parentId);
                        if (child == null || parent == null) continue;
                        child.addParent(parentType, parent);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        return configuredObjects.values();
    }

    protected void upgradeIfNecessary(ConfiguredObject<?> parent) throws StoreException {
        block29: {
            Connection connection = null;
            try {
                connection = this.newAutoCommitConnection();
                boolean tableExists = this.tableExists(this.getConfigurationVersionTableName(), connection);
                if (tableExists) {
                    int configVersion = this.getConfigVersion(connection);
                    this.getLogger().debug("Upgrader read existing config version {}", (Object)configVersion);
                    switch (configVersion) {
                        case 7: {
                            this.upgradeFromV7(parent);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Cannot upgrade from configuration version : " + configVersion);
                        }
                    }
                    break block29;
                }
                try (PreparedStatement statement = connection.prepareStatement(String.format("SELECT version FROM %s", this.getConfigStructureVersionTableName()));
                     ResultSet rs = statement.executeQuery();){
                    if (!rs.next()) {
                        throw new StoreException(this.getConfigStructureVersionTableName() + " does not contain the configuration database version");
                    }
                    int version = rs.getInt(1);
                    switch (version) {
                        case 1: {
                            this.upgradeFromConfigVersion1();
                        }
                        case 2: {
                            return;
                        }
                    }
                    throw new StoreException("Unknown configuration database version: " + version);
                }
            }
            catch (SQLException se) {
                throw new StoreException("Failed to upgrade database", (Throwable)se);
            }
            finally {
                JdbcUtils.closeConnection(connection, this.getLogger());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeFromConfigVersion1() throws SQLException {
        try (Connection connection = this.newConnection();){
            PreparedStatement insertStmt;
            ResultSet rs;
            try (PreparedStatement stmt = connection.prepareStatement(String.format("SELECT id, object_type, attributes FROM %s", this.getVersion1ConfiguredObjectsTableName()));){
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String objectType = rs.getString(2);
                        String attributes = this.getBlobAsString(rs, 3);
                        insertStmt = connection.prepareStatement(String.format("INSERT INTO %s ( id, object_type, attributes) VALUES (?,?,?)", this.getConfiguredObjectsTableName()));
                        try {
                            insertStmt.setString(1, id);
                            insertStmt.setString(2, objectType);
                            if (attributes == null) {
                                insertStmt.setNull(3, 2004);
                            } else {
                                byte[] attributesAsBytes = attributes.getBytes(StandardCharsets.UTF_8);
                                try (ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);){
                                    insertStmt.setBinaryStream(3, (InputStream)bis, attributesAsBytes.length);
                                }
                                catch (IOException e) {
                                    throw new StoreException("Unexpected exception: " + e.getMessage(), (Throwable)e);
                                }
                            }
                            insertStmt.execute();
                        }
                        finally {
                            if (insertStmt == null) continue;
                            insertStmt.close();
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            stmt = connection.prepareStatement(String.format("SELECT child_id, parent_type, parent_id FROM %s", this.getVersion1ConfiguredObjectHierarchyTableName()));
            try {
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        String childId = rs.getString(1);
                        String parentType = rs.getString(2);
                        String parentId = rs.getString(3);
                        insertStmt = connection.prepareStatement(String.format("INSERT INTO %s ( child_id, parent_type, parent_id) VALUES (?,?,?)", this.getConfiguredObjectHierarchyTableName()));
                        try {
                            insertStmt.setString(1, childId);
                            insertStmt.setString(2, parentType);
                            insertStmt.setString(3, parentId);
                            insertStmt.execute();
                        }
                        finally {
                            if (insertStmt == null) continue;
                            insertStmt.close();
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            this.updateConfigStructureVersionTableName(connection, 2);
            connection.commit();
        }
        try (Connection c = this.newAutoCommitConnection();){
            JdbcUtils.dropTables(c, this.getLogger(), Arrays.asList(this.getVersion1ConfiguredObjectHierarchyTableName(), this.getVersion1ConfiguredObjectsTableName()));
            return;
        }
    }

    private void updateConfigStructureVersionTableName(Connection conn, int newVersion) throws SQLException {
        try (PreparedStatement statement = conn.prepareStatement("UPDATE " + this.getConfigStructureVersionTableName() + " SET version = ?");){
            statement.setInt(1, newVersion);
            statement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeFromV7(ConfiguredObject<?> parent) throws SQLException {
        Map<String, String> defaultExchanges = Map.of("amq.direct", "direct", "amq.topic", "topic", "amq.fanout", "fanout", "amq.match", "headers");
        try (Connection connection = this.newConnection();){
            String virtualHostName = parent.getName();
            UUID virtualHostId = UUIDGenerator.generateVhostUUID((String)virtualHostName);
            Object stringifiedConfigVersion = "0.0";
            boolean tableExists = this.tableExists(this.getConfigurationVersionTableName(), connection);
            if (tableExists) {
                int configVersion = this.getConfigVersion(connection);
                this.getLogger().debug("Upgrader read existing config version {}", (Object)configVersion);
                stringifiedConfigVersion = "0." + configVersion;
            }
            HashMap<String, Object> virtualHostAttributes = new HashMap<String, Object>();
            virtualHostAttributes.put("modelVersion", stringifiedConfigVersion);
            virtualHostAttributes.put("name", virtualHostName);
            ConfiguredObjectRecordImpl virtualHostRecord = new ConfiguredObjectRecordImpl(virtualHostId, "VirtualHost", virtualHostAttributes);
            this.insertConfiguredObject(virtualHostRecord, connection);
            this.getLogger().debug("Upgrader created VirtualHost configuration entry with config version {}", stringifiedConfigVersion);
            HashMap<UUID, Map> bindingsToUpdate = new HashMap<UUID, Map>();
            ArrayList<UUID> others = new ArrayList<UUID>();
            ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)true);
            try (PreparedStatement stmt = connection.prepareStatement("SELECT id, object_type, attributes FROM " + this.getConfiguredObjectsTableName());){
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        UUID uUID = UUID.fromString(rs.getString(1));
                        String objectType = rs.getString(2);
                        if ("VirtualHost".equals(objectType)) continue;
                        Map attributes = (Map)objectMapper.readValue(this.getBlobAsString(rs, 3), Map.class);
                        if (objectType.endsWith("Binding")) {
                            bindingsToUpdate.put(uUID, attributes);
                            continue;
                        }
                        if (objectType.equals("Exchange")) {
                            defaultExchanges.remove((String)attributes.get("name"));
                        }
                        others.add(uUID);
                    }
                }
                catch (IOException e) {
                    throw new StoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
                }
            }
            stmt = connection.prepareStatement("INSERT INTO " + this.getConfiguredObjectHierarchyTableName() + " ( child_id, parent_type, parent_id) VALUES (?,?,?)");
            try {
                for (UUID uUID : others) {
                    stmt.setString(1, uUID.toString());
                    stmt.setString(2, "VirtualHost");
                    stmt.setString(3, virtualHostId.toString());
                    stmt.execute();
                }
                for (Map.Entry entry : bindingsToUpdate.entrySet()) {
                    stmt.setString(1, ((UUID)entry.getKey()).toString());
                    stmt.setString(2, "Queue");
                    stmt.setString(3, ((Map)entry.getValue()).remove("queue").toString());
                    stmt.execute();
                    stmt.setString(1, ((UUID)entry.getKey()).toString());
                    stmt.setString(2, "Exchange");
                    stmt.setString(3, ((Map)entry.getValue()).remove("exchange").toString());
                    stmt.execute();
                }
            }
            finally {
                stmt.close();
            }
            for (Map.Entry entry : defaultExchanges.entrySet()) {
                UUID id = UUIDGenerator.generateExchangeUUID((String)((String)entry.getKey()), (String)virtualHostName);
                HashMap<String, Object> exchangeAttributes = new HashMap<String, Object>();
                exchangeAttributes.put("name", entry.getKey());
                exchangeAttributes.put("type", entry.getValue());
                exchangeAttributes.put("lifetimePolicy", "PERMANENT");
                Map<String, UUID> parents = Map.of("VirtualHost", virtualHostRecord.getId());
                org.apache.qpid.server.store.ConfiguredObjectRecordImpl exchangeRecord = new org.apache.qpid.server.store.ConfiguredObjectRecordImpl(id, "Exchange", exchangeAttributes, parents);
                this.insertConfiguredObject((ConfiguredObjectRecord)exchangeRecord, connection);
            }
            stmt = connection.prepareStatement("UPDATE " + this.getConfiguredObjectsTableName() + " set object_type =?, attributes = ? where id = ?");
            try {
                for (Map.Entry entry : bindingsToUpdate.entrySet()) {
                    stmt.setString(1, "Binding");
                    byte[] attributesAsBytes = objectMapper.writeValueAsBytes(entry.getValue());
                    ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                    stmt.setBinaryStream(2, (InputStream)bis, attributesAsBytes.length);
                    stmt.setString(3, ((UUID)entry.getKey()).toString());
                    stmt.execute();
                }
            }
            catch (IOException e) {
                throw new StoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
            }
            finally {
                stmt.close();
            }
            if (tableExists) {
                this.dropConfigVersionTable(connection);
            }
            connection.commit();
        }
    }

    protected abstract Logger getLogger();

    protected abstract String getSqlBlobType();

    protected abstract String getSqlBlobStorage(String var1);

    protected abstract String getSqlVarBinaryType(int var1);

    protected abstract String getSqlBigIntType();

    protected void createOrOpenConfigurationStoreDatabase() throws StoreException {
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            this.createConfiguredObjectsTable(conn);
            this.createConfiguredObjectHierarchyTable(conn);
            this.createConfigurationStructureVersionTable(conn);
        }
        catch (SQLException e) {
            throw new StoreException("Unable to open configuration tables", (Throwable)e);
        }
        finally {
            JdbcUtils.closeConnection(conn, this.getLogger());
        }
    }

    private void createConfigurationStructureVersionTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getConfigStructureVersionTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(String.format("CREATE TABLE %s ( version int not null )", this.getConfigStructureVersionTableName()));
            }
            int version = this.tableExists(this.getVersion1ConfiguredObjectsTableName(), conn) ? 1 : 2;
            try (PreparedStatement pstmt = conn.prepareStatement(String.format("INSERT INTO %s ( version ) VALUES ( ? )", this.getConfigStructureVersionTableName()));){
                pstmt.setInt(1, version);
                pstmt.execute();
            }
        }
    }

    private void dropConfigVersionTable(Connection conn) throws SQLException {
        this.dropTable(conn, this.getConfigurationVersionTableName());
    }

    private void dropTable(Connection conn, String tableName) throws SQLException {
        if (!this.tableExists(tableName, conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute(String.format("DROP TABLE %s", tableName));
            }
        }
    }

    private void createConfiguredObjectsTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getConfiguredObjectsTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getConfiguredObjectsTableName() + " ( id VARCHAR(36) not null, object_type varchar(255), attributes " + this.getSqlBlobType() + ",  PRIMARY KEY (id))");
            }
        }
    }

    private void createConfiguredObjectHierarchyTable(Connection conn) throws SQLException {
        if (!this.tableExists(this.getConfiguredObjectHierarchyTableName(), conn)) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + this.getConfiguredObjectHierarchyTableName() + " ( child_id VARCHAR(36) not null, parent_type varchar(255), parent_id VARCHAR(36),  PRIMARY KEY (child_id, parent_type))");
            }
        }
    }

    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        return JdbcUtils.tableExists(tableName, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConfigVersion(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            ResultSet rs;
            block8: {
                int n;
                rs = stmt.executeQuery("SELECT version FROM " + this.getConfigurationVersionTableName());
                try {
                    if (!rs.next()) break block8;
                    n = rs.getInt(1);
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return n;
            }
            int n = 0;
            rs.close();
            return n;
        }
    }

    public void create(ConfiguredObjectRecord object) throws StoreException {
        this.assertState(State.OPEN);
        try (Connection conn = this.newConnection();){
            this.insertConfiguredObject(object, conn);
            conn.commit();
        }
        catch (SQLException e) {
            throw new StoreException("Error creating ConfiguredObject " + object, (Throwable)e);
        }
    }

    protected Connection newAutoCommitConnection() throws SQLException {
        Connection connection = this.newConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    protected Connection newConnection() throws SQLException {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    protected abstract Connection getConnection() throws SQLException;

    private void insertConfiguredObject(ConfiguredObjectRecord configuredObject, Connection conn) throws StoreException {
        block23: {
            try (PreparedStatement stmt = conn.prepareStatement("SELECT object_type, attributes FROM " + this.getConfiguredObjectsTableName() + " where id = ?");){
                boolean exists;
                stmt.setString(1, configuredObject.getId().toString());
                try (ResultSet rs = stmt.executeQuery();){
                    exists = rs.next();
                }
                if (exists) break block23;
                try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO " + this.getConfiguredObjectsTableName() + " ( id, object_type, attributes) VALUES (?,?,?)");){
                    insertStmt.setString(1, configuredObject.getId().toString());
                    insertStmt.setString(2, configuredObject.getType());
                    if (configuredObject.getAttributes() == null) {
                        insertStmt.setNull(3, 2004);
                    } else {
                        Map attributes = configuredObject.getAttributes();
                        ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)true);
                        byte[] attributesAsBytes = objectMapper.writeValueAsBytes((Object)attributes);
                        ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                        insertStmt.setBinaryStream(3, (InputStream)bis, attributesAsBytes.length);
                    }
                    insertStmt.execute();
                }
                this.writeHierarchy(configuredObject, conn);
            }
            catch (IOException | SQLException e) {
                throw new StoreException("Error inserting of configured object " + configuredObject + " into database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public UUID[] remove(ConfiguredObjectRecord ... objects) throws StoreException {
        this.assertState(State.OPEN);
        ArrayList<UUID> removed = new ArrayList<UUID>(objects.length);
        try (Connection conn = this.newAutoCommitConnection();){
            for (ConfiguredObjectRecord record : objects) {
                if (this.removeConfiguredObject(record.getId(), conn) == 0) continue;
                removed.add(record.getId());
            }
        }
        catch (SQLException e) {
            throw new StoreException("Error deleting of configured objects " + Arrays.asList(objects) + " from database: " + e.getMessage(), (Throwable)e);
        }
        return removed.toArray(new UUID[removed.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeConfiguredObject(UUID id, Connection conn) throws SQLException {
        int results;
        try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM " + this.getConfiguredObjectsTableName() + " where id = ?");){
            stmt.setString(1, id.toString());
            results = stmt.executeUpdate();
        }
        stmt = conn.prepareStatement("DELETE FROM " + this.getConfiguredObjectHierarchyTableName() + " where child_id = ?");
        try {
            stmt.setString(1, id.toString());
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
        return results;
    }

    public void update(boolean createIfNecessary, ConfiguredObjectRecord ... records) throws StoreException {
        this.assertState(State.OPEN);
        try (Connection conn = this.newConnection();){
            for (ConfiguredObjectRecord record : records) {
                this.updateConfiguredObject(record, createIfNecessary, conn);
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new StoreException("Error updating configured objects in database: " + e.getMessage(), (Throwable)e);
        }
    }

    public void addDeleteAction(Action<Connection> action) {
        this._deleteActions.add(action);
    }

    public void removeDeleteAction(Action<Connection> action) {
        this._deleteActions.remove(action);
    }

    private void updateConfiguredObject(ConfiguredObjectRecord configuredObject, boolean createIfNecessary, Connection conn) throws SQLException, StoreException {
        block31: {
            try (PreparedStatement stmt = conn.prepareStatement("SELECT object_type, attributes FROM " + this.getConfiguredObjectsTableName() + " where id = ?");){
                stmt.setString(1, configuredObject.getId().toString());
                try (ResultSet rs = stmt.executeQuery();){
                    ObjectMapper objectMapper = ConfiguredObjectJacksonModule.newObjectMapper((boolean)true);
                    if (rs.next()) {
                        try (PreparedStatement stmt2 = conn.prepareStatement("UPDATE " + this.getConfiguredObjectsTableName() + " set object_type =?, attributes = ? where id = ?");){
                            stmt2.setString(1, configuredObject.getType());
                            if (configuredObject.getAttributes() != null) {
                                byte[] attributesAsBytes = objectMapper.writeValueAsBytes((Object)configuredObject.getAttributes());
                                ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                                stmt2.setBinaryStream(2, (InputStream)bis, attributesAsBytes.length);
                            } else {
                                stmt2.setNull(2, 2004);
                            }
                            stmt2.setString(3, configuredObject.getId().toString());
                            stmt2.execute();
                            break block31;
                        }
                    }
                    if (!createIfNecessary) break block31;
                    try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO " + this.getConfiguredObjectsTableName() + " ( id, object_type, attributes) VALUES (?,?,?)");){
                        insertStmt.setString(1, configuredObject.getId().toString());
                        insertStmt.setString(2, configuredObject.getType());
                        if (configuredObject.getAttributes() == null) {
                            insertStmt.setNull(3, 2004);
                        } else {
                            Map attributes = configuredObject.getAttributes();
                            byte[] attributesAsBytes = objectMapper.writeValueAsBytes((Object)attributes);
                            ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                            insertStmt.setBinaryStream(3, (InputStream)bis, attributesAsBytes.length);
                        }
                        insertStmt.execute();
                    }
                    this.writeHierarchy(configuredObject, conn);
                }
            }
            catch (IOException e) {
                throw new StoreException("Error updating configured object " + configuredObject + " in database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void writeHierarchy(ConfiguredObjectRecord configuredObject, Connection conn) throws SQLException, StoreException {
        try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO " + this.getConfiguredObjectHierarchyTableName() + " ( child_id, parent_type, parent_id) VALUES (?,?,?)");){
            for (Map.Entry parentEntry : configuredObject.getParents().entrySet()) {
                insertStmt.setString(1, configuredObject.getId().toString());
                insertStmt.setString(2, (String)parentEntry.getKey());
                insertStmt.setString(3, ((UUID)parentEntry.getValue()).toString());
                insertStmt.execute();
            }
        }
    }

    protected abstract String getBlobAsString(ResultSet var1, int var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDelete(Connection conn) {
        try {
            for (Action<Connection> deleteAction : this._deleteActions) {
                deleteAction.performAction((Object)conn);
            }
            this._deleteActions.clear();
        }
        catch (Throwable throwable) {
            JdbcUtils.dropTables(conn, this.getLogger(), Arrays.asList(this.getConfiguredObjectsTableName(), this.getConfiguredObjectHierarchyTableName(), this.getConfigStructureVersionTableName()));
            throw throwable;
        }
        JdbcUtils.dropTables(conn, this.getLogger(), Arrays.asList(this.getConfiguredObjectsTableName(), this.getConfiguredObjectHierarchyTableName(), this.getConfigStructureVersionTableName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertState(State state) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                throw new IllegalStateException("The store must be in state " + state + " to perform this operation, but it is in state " + this._state + " instead");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeState(State oldState, State newState) {
        Object object = this._lock;
        synchronized (object) {
            this.assertState(oldState);
            this._state = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setState(State newState) {
        Object object = this._lock;
        synchronized (object) {
            this._state = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doIfNotState(State state, Runnable action) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                action.run();
            }
        }
    }

    private static final class ConfiguredObjectRecordImpl
    implements ConfiguredObjectRecord {
        private final UUID _id;
        private final String _type;
        private final Map<String, Object> _attributes;
        private final Map<String, UUID> _parents = new HashMap<String, UUID>();

        private ConfiguredObjectRecordImpl(UUID id, String type, Map<String, Object> attributes) {
            this._id = id;
            this._type = type;
            this._attributes = Collections.unmodifiableMap(attributes);
        }

        public UUID getId() {
            return this._id;
        }

        public String getType() {
            return this._type;
        }

        private void addParent(String parentType, ConfiguredObjectRecord parent) {
            this._parents.put(parentType, parent.getId());
        }

        public Map<String, Object> getAttributes() {
            return this._attributes;
        }

        public Map<String, UUID> getParents() {
            return Collections.unmodifiableMap(this._parents);
        }

        public String toString() {
            return "ConfiguredObjectRecordImpl [_id=" + this._id + ", _type=" + this._type + ", _attributes=" + this._attributes + ", _parents=" + this._parents + "]";
        }
    }

    public static enum State {
        CLOSED,
        CONFIGURED,
        OPEN;

    }
}

