/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingPolicyDecorator
implements RollingPolicy {
    public static final int DEFAULT_RESCAN_DELAY = 5000;
    public static final String ROLLOVER_RESCAN_DELAY_MS_PROPERTY_NAME = "qpid.logger_rollover_rescan_delay_ms";
    public static final int DEFAULT_RESCAN_LIMIT = 60;
    public static final String ROLLOVER_RESCAN_LIMIT_PROPERTY_NAME = "qpid.logger_rollover_rescan_limit";
    private static final Logger LOGGER = LoggerFactory.getLogger(RollingPolicyDecorator.class);
    private final RollingPolicyBase _decorated;
    private final RolloverListener _listener;
    private final Path _rolledFilesBaseFolder;
    private final Pattern _rolledFileRegExp;
    private final ScheduledExecutorService _executorService;
    private final long _rescanDelayMillis = Long.getLong("qpid.logger_rollover_rescan_delay_ms", 5000L);
    private final long _rescanLimit = Long.getLong("qpid.logger_rollover_rescan_limit", 60L);
    private final Lock _publishResultsLock = new ReentrantLock();
    private ScanTask _currentScanTask;
    private String[] _previousScanResults;

    public RollingPolicyDecorator(RollingPolicyBase decorated, RolloverListener listener, ScheduledExecutorService executorService) {
        this._decorated = decorated;
        this._listener = listener;
        this._executorService = executorService;
        String filePathPattern = this._decorated.getFileNamePattern();
        String filePathRegExp = new FileNamePattern(filePathPattern, this._decorated.getContext()).toRegex();
        FilePathBaseFolderAndPatternPair pair = new FilePathBaseFolderAndPatternPair(filePathRegExp);
        this._rolledFilesBaseFolder = pair.getBaseFolder();
        this._rolledFileRegExp = pair.getPattern();
        this._currentScanTask = null;
    }

    public void rollover() throws RolloverFailure {
        ScanTask task = this.createScanTaskAndCancelInProgress();
        this._decorated.rollover();
        this._executorService.execute(task);
    }

    public String getActiveFileName() {
        return this._decorated.getActiveFileName();
    }

    public CompressionMode getCompressionMode() {
        return this._decorated.getCompressionMode();
    }

    public void setParent(FileAppender appender) {
        this._decorated.setParent(appender);
    }

    public void start() {
        ScanTask task = this.createScanTaskAndCancelInProgress();
        this._decorated.start();
        this._executorService.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._decorated.stop();
        Lock lock = this._publishResultsLock;
        synchronized (lock) {
            if (this._currentScanTask != null) {
                this._currentScanTask.cancel();
            }
            this._previousScanResults = null;
        }
    }

    public boolean isStarted() {
        return this._decorated.isStarted();
    }

    public RollingPolicyBase getDecorated() {
        return this._decorated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanTask createScanTaskAndCancelInProgress() {
        ScanTask task = new ScanTask();
        Lock lock = this._publishResultsLock;
        synchronized (lock) {
            if (this._currentScanTask != null) {
                this._currentScanTask.cancel();
            }
            this._currentScanTask = task;
        }
        return task;
    }

    private static class FilePathBaseFolderAndPatternPair {
        private final Path _baseFolder;
        private final Pattern _pattern;

        public FilePathBaseFolderAndPatternPair(String fileNamePattern) {
            String path;
            int firstDigitPatternPosition = fileNamePattern.indexOf("\\d");
            if (firstDigitPatternPosition == -1) {
                throw new RuntimeException("Rolling policy file pattern does not seem to contain date or integer token");
            }
            int slashBeforeDigitPatternPosition = fileNamePattern.lastIndexOf("/", firstDigitPatternPosition);
            if (slashBeforeDigitPatternPosition != -1) {
                path = fileNamePattern.substring(0, slashBeforeDigitPatternPosition);
                fileNamePattern = fileNamePattern.substring(slashBeforeDigitPatternPosition + 1);
            } else {
                path = System.getProperty("user.dir");
            }
            this._baseFolder = new File(path).toPath().toAbsolutePath();
            this._pattern = Pattern.compile(Pattern.quote(path) + "/" + fileNamePattern);
        }

        public Path getBaseFolder() {
            return this._baseFolder;
        }

        public Pattern getPattern() {
            return this._pattern;
        }
    }

    private class ScanTask
    implements Runnable {
        private int _rescanCounter;
        private volatile boolean _canceled;

        private ScanTask() {
        }

        @Override
        public void run() {
            String[] rolloverFiles;
            if (!(this.isCanceled() || this.publishScanResults(rolloverFiles = this.scan()) || this.isCanceled())) {
                if ((long)this._rescanCounter < RollingPolicyDecorator.this._rescanLimit) {
                    ++this._rescanCounter;
                    RollingPolicyDecorator.this._executorService.schedule(this, RollingPolicyDecorator.this._rescanDelayMillis, TimeUnit.MILLISECONDS);
                } else {
                    RollingPolicyDecorator.this._listener.onNoRolloverDetected(RollingPolicyDecorator.this._rolledFilesBaseFolder, rolloverFiles);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean publishScanResults(String[] rolloverFiles) {
            boolean published = false;
            if (rolloverFiles != null && !this.isCanceled()) {
                Lock lock = RollingPolicyDecorator.this._publishResultsLock;
                synchronized (lock) {
                    if (!(this.isCanceled() || RollingPolicyDecorator.this._previousScanResults != null && Arrays.equals(rolloverFiles, RollingPolicyDecorator.this._previousScanResults))) {
                        RollingPolicyDecorator.this._previousScanResults = rolloverFiles;
                        published = true;
                    }
                }
            }
            if (published) {
                RollingPolicyDecorator.this._listener.onRollover(RollingPolicyDecorator.this._rolledFilesBaseFolder, rolloverFiles);
            }
            return published;
        }

        public String[] scan() {
            final ArrayList<Path> rolledFiles = new ArrayList<Path>();
            try {
                Files.walkFileTree(RollingPolicyDecorator.this._rolledFilesBaseFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return ScanTask.this.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String absolutePath = file.toAbsolutePath().toString();
                        if (File.separatorChar == '\\') {
                            absolutePath = absolutePath.replace('\\', '/');
                        }
                        if (RollingPolicyDecorator.this._rolledFileRegExp.matcher(absolutePath).matches()) {
                            rolledFiles.add(file);
                        }
                        return ScanTask.this.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return ScanTask.this.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return ScanTask.this.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("Unexpected IOException while scanning for rollover files.", (Throwable)e);
            }
            return this.isCanceled() ? null : this.relativizeAndSort(RollingPolicyDecorator.this._rolledFilesBaseFolder, rolledFiles);
        }

        public void cancel() {
            this._canceled = true;
        }

        private String[] relativizeAndSort(Path parent, List<Path> rolledFiles) {
            String[] results = new String[rolledFiles.size()];
            int i = 0;
            for (Path f : rolledFiles) {
                results[i++] = parent.relativize(f).toString();
            }
            Arrays.sort(results, String::compareTo);
            return results;
        }

        public boolean isCanceled() {
            return this._canceled || Thread.currentThread().isInterrupted();
        }
    }

    public static interface RolloverListener {
        public void onRollover(Path var1, String[] var2);

        public void onNoRolloverDetected(Path var1, String[] var2);
    }
}

