/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.qpid.client.url.URLParser;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnectionURL
implements ConnectionURL {
    private String _url;
    private String _failoverMethod;
    private Map<String, String> _failoverOptions;
    private Map<String, String> _options;
    private List<BrokerDetails> _brokers;
    private String _clientName;
    private String _username;
    private String _password;
    private String _virtualHost;
    private AMQShortString _defaultQueueExchangeName;
    private AMQShortString _defaultTopicExchangeName;
    private AMQShortString _temporaryTopicExchangeName;
    private AMQShortString _temporaryQueueExchangeName;

    public AMQConnectionURL(String fullURL) throws URLSyntaxException {
        if (fullURL == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        this._url = fullURL;
        this._options = new HashMap<String, String>();
        this._brokers = new LinkedList<BrokerDetails>();
        this._failoverOptions = new HashMap<String, String>();
        new URLParser(this);
    }

    @Override
    public String getURL() {
        return this._url;
    }

    public Map<String, String> getOptions() {
        return this._options;
    }

    @Override
    public String getFailoverMethod() {
        return this._failoverMethod;
    }

    public void setFailoverMethod(String failoverMethod) {
        this._failoverMethod = failoverMethod;
    }

    public Map<String, String> getFailoverOptions() {
        return this._failoverOptions;
    }

    @Override
    public String getFailoverOption(String key) {
        return this._failoverOptions.get(key);
    }

    public void setFailoverOption(String key, String value) {
        this._failoverOptions.put(key, value);
    }

    @Override
    public int getBrokerCount() {
        return this._brokers.size();
    }

    @Override
    public BrokerDetails getBrokerDetails(int index) {
        if (index < this._brokers.size()) {
            return this._brokers.get(index);
        }
        return null;
    }

    @Override
    public void addBrokerDetails(BrokerDetails broker) {
        if (!this._brokers.contains(broker)) {
            this._brokers.add(broker);
        }
    }

    @Override
    public void setBrokerDetails(List<BrokerDetails> brokers) {
        this._brokers = brokers;
    }

    @Override
    public List<BrokerDetails> getAllBrokerDetails() {
        return this._brokers;
    }

    @Override
    public String getClientName() {
        return this._clientName;
    }

    @Override
    public void setClientName(String clientName) {
        this._clientName = clientName;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public void setUsername(String username) {
        this._username = username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public String getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void setVirtualHost(String virtuaHost) {
        this._virtualHost = virtuaHost;
    }

    @Override
    public String getOption(String key) {
        return this._options.get(key);
    }

    @Override
    public void setOption(String key, String value) {
        this._options.put(key, value);
    }

    @Override
    public AMQShortString getDefaultQueueExchangeName() {
        return this._defaultQueueExchangeName;
    }

    public void setDefaultQueueExchangeName(AMQShortString defaultQueueExchangeName) {
        this._defaultQueueExchangeName = defaultQueueExchangeName;
    }

    @Override
    public AMQShortString getDefaultTopicExchangeName() {
        return this._defaultTopicExchangeName;
    }

    public void setDefaultTopicExchangeName(AMQShortString defaultTopicExchangeName) {
        this._defaultTopicExchangeName = defaultTopicExchangeName;
    }

    @Override
    public AMQShortString getTemporaryQueueExchangeName() {
        return this._temporaryQueueExchangeName;
    }

    public void setTemporaryQueueExchangeName(AMQShortString temporaryQueueExchangeName) {
        this._temporaryQueueExchangeName = temporaryQueueExchangeName;
    }

    @Override
    public AMQShortString getTemporaryTopicExchangeName() {
        return this._temporaryTopicExchangeName;
    }

    public void setTemporaryTopicExchangeName(AMQShortString temporaryTopicExchangeName) {
        this._temporaryTopicExchangeName = temporaryTopicExchangeName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("amqp");
        sb.append("://");
        if (this._username != null) {
            sb.append(this._username);
            if (this._password != null) {
                sb.append(':');
                sb.append("********");
            }
            sb.append('@');
        }
        sb.append(this._clientName);
        sb.append(this._virtualHost);
        sb.append(this.optionsToString());
        return sb.toString();
    }

    private String optionsToString() {
        StringBuffer sb = new StringBuffer("?");
        if (!this._options.isEmpty()) {
            for (Map.Entry<String, String> option : this._options.entrySet()) {
                sb.append(option.getKey()).append("='").append(option.getValue()).append("'");
                sb.append('&');
            }
        }
        sb.append("brokerlist").append("='");
        for (BrokerDetails service : this._brokers) {
            sb.append(((Object)service).toString());
            sb.append(';');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("'");
        if (this._failoverMethod != null) {
            sb.append('&');
            sb.append("failover");
            sb.append("='");
            sb.append(this._failoverMethod);
            sb.append(URLHelper.printOptions(this._failoverOptions));
            sb.append("'");
        }
        return sb.toString();
    }
}

