/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.messaging.address;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.messaging.address.QpidExchangeOptions;
import org.apache.qpid.client.messaging.address.QpidQueueOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    private int _nodeType = 3;
    private boolean _isDurable;
    private boolean _isAutoDelete;
    private String _alternateExchange;
    private List<AMQDestination.Binding> _bindings = new ArrayList<AMQDestination.Binding>();
    private Map<String, Object> _declareArgs = Collections.emptyMap();

    protected Node(int nodeType) {
        this._nodeType = nodeType;
    }

    public int getType() {
        return this._nodeType;
    }

    public boolean isDurable() {
        return this._isDurable;
    }

    public void setDurable(boolean durable) {
        this._isDurable = durable;
    }

    public boolean isAutoDelete() {
        return this._isAutoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this._isAutoDelete = autoDelete;
    }

    public String getAlternateExchange() {
        return this._alternateExchange;
    }

    public void setAlternateExchange(String altExchange) {
        this._alternateExchange = altExchange;
    }

    public List<AMQDestination.Binding> getBindings() {
        return this._bindings;
    }

    public void setBindings(List<AMQDestination.Binding> bindings) {
        this._bindings = bindings;
    }

    public void addBinding(AMQDestination.Binding binding) {
        this._bindings.add(binding);
    }

    public Map<String, Object> getDeclareArgs() {
        return this._declareArgs;
    }

    public void setDeclareArgs(Map<String, Object> options) {
        this._declareArgs = options;
    }

    public static class UnknownNodeType
    extends Node {
        public UnknownNodeType() {
            super(3);
        }
    }

    public static class ExchangeNode
    extends Node {
        private QpidExchangeOptions _exchangeOptions = new QpidExchangeOptions();
        private String _exchangeType;

        public ExchangeNode() {
            super(2);
        }

        public String getExchangeType() {
            return this._exchangeType;
        }

        public void setExchangeType(String exchangeType) {
            this._exchangeType = exchangeType;
        }
    }

    public static class QueueNode
    extends Node {
        private boolean _isExclusive;
        private QpidQueueOptions _queueOptions = new QpidQueueOptions();

        public QueueNode() {
            super(1);
        }

        public boolean isExclusive() {
            return this._isExclusive;
        }

        public void setExclusive(boolean exclusive) {
            this._isExclusive = exclusive;
        }
    }
}

