/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.protocol;

class HeartbeatDiagnostics {
    private static final Diagnostics _impl = HeartbeatDiagnostics.init();

    private HeartbeatDiagnostics() {
    }

    private static Diagnostics init() {
        return Boolean.getBoolean("amqj.heartbeat.diagnostics") ? new On() : new Off();
    }

    static void sent() {
        _impl.sent();
    }

    static void timeout() {
        _impl.timeout();
    }

    static void received(boolean heartbeat) {
        _impl.received(heartbeat);
    }

    static void init(int delay, int timeout) {
        _impl.init(delay, timeout);
    }

    private static class Off
    implements Diagnostics {
        private Off() {
        }

        public void sent() {
        }

        public void timeout() {
        }

        public void received(boolean heartbeat) {
        }

        public void init(int delay, int timeout) {
        }
    }

    private static class On
    implements Diagnostics {
        private final String[] messages = new String[50];
        private int i;

        private On() {
        }

        private void save(String msg) {
            this.messages[this.i++] = msg;
            if (this.i >= this.messages.length) {
                this.i = 0;
            }
        }

        public void sent() {
            this.save(System.currentTimeMillis() + ": sent heartbeat");
        }

        public void timeout() {
            for (int i = 0; i < this.messages.length; ++i) {
                if (this.messages[i] == null) continue;
                System.out.println(this.messages[i]);
            }
            System.out.println(System.currentTimeMillis() + ": timed out");
        }

        public void received(boolean heartbeat) {
            this.save(System.currentTimeMillis() + ": received " + (heartbeat ? "heartbeat" : "data"));
        }

        public void init(int delay, int timeout) {
            System.out.println(System.currentTimeMillis() + ": initialised delay=" + delay + ", timeout=" + timeout);
        }
    }

    private static interface Diagnostics {
        public void sent();

        public void timeout();

        public void received(boolean var1);

        public void init(int var1, int var2);
    }
}

