/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.jdbc.util;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.apache.rave.jdbc.util.SqlFileParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DataSourcePopulator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(DataSourcePopulator.class);
    protected String executeScriptQuery;
    protected List<Resource> scriptLocations;

    public DataSourcePopulator() {
    }

    public DataSourcePopulator(List<Resource> scriptLocations, String executeScriptQuery) {
        this.scriptLocations = scriptLocations;
        this.executeScriptQuery = executeScriptQuery;
    }

    public void setExecuteScriptQuery(String executeScriptQuery) {
        this.executeScriptQuery = executeScriptQuery;
    }

    public void setScriptLocations(List<Resource> scriptLocations) {
        this.scriptLocations = scriptLocations;
    }

    public void initialize(DataSource dataSource) {
        this.validateProperties();
        this.populateDataSourceIfNecessary(dataSource);
    }

    protected void validateProperties() {
        if (this.scriptLocations == null) {
            throw new IllegalArgumentException("The path to the database schema DDL is required");
        }
    }

    protected void populateDataSourceIfNecessary(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            if (DataSourcePopulator.testExecuteScriptQuery(conn, this.executeScriptQuery)) {
                logger.debug("Database is empty.  Loading script files");
                DataSourcePopulator.executeScripts(conn, this.scriptLocations);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying or populating database", e);
        }
        finally {
            DataSourcePopulator.closeConnection(conn);
        }
    }

    protected static void executeScripts(Connection connection, List<Resource> resources) {
        for (Resource script : resources) {
            try {
                String sql = new SqlFileParser(script).getSQL();
                logger.debug("Executing sql:\n" + sql);
                DataSourcePopulator.executeSql(sql, connection);
                logger.debug("Successfully executed statement");
            }
            catch (IOException e) {
                throw new RuntimeException("File IO Exception while loading " + script.getFilename(), e);
            }
            catch (SQLException e) {
                throw new RuntimeException("SQL exception occurred loading data from " + script.getFilename(), e);
            }
        }
    }

    protected static boolean testExecuteScriptQuery(Connection conn, String executeScriptQuery) {
        boolean result;
        try {
            result = executeScriptQuery == null || !DataSourcePopulator.executeQuery(conn, executeScriptQuery).first();
        }
        catch (SQLException e) {
            logger.warn("SQL Exception while running the query used to determine if the data should be loaded: " + e.getMessage());
            result = e.getMessage().toLowerCase().matches("table \".*\" not found.*\n*.*");
        }
        logger.debug("Executed query " + executeScriptQuery + " with result " + result);
        return result;
    }

    protected static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error("Error closing connection to database", (Throwable)e);
            }
        }
    }

    protected static ResultSet executeQuery(Connection conn, String executeScriptQuery) throws SQLException {
        Statement statement = conn.createStatement(1004, 1007);
        return statement.executeQuery(executeScriptQuery);
    }

    protected static void executeSql(String sql, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute(sql);
    }
}

