/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.jdbc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.io.Resource;

public class SqlFileParser {
    private static final Pattern WORD_PATTERN = Pattern.compile("^([a-zA-Z]*)[ ;]");
    private static final String CHILD_SCRIPT_INDICATOR = "@@";
    private static final Set<String> commandSet = new HashSet<String>();
    private Stack<State> stateStack = new Stack();
    private Resource resource;

    public SqlFileParser(Resource resource) {
        this.resource = resource;
    }

    public String getSQL() throws IOException {
        return this.processResource(this.resource);
    }

    private String processResource(Resource res) throws IOException {
        StringBuilder sql = new StringBuilder();
        File resourceFile = res.getFile();
        this.stateStack.push(State.INIT);
        this.processFile(resourceFile, sql);
        this.stateStack.pop();
        return sql.toString();
    }

    private void processFile(File file, StringBuilder sql) throws IOException {
        BufferedReader fileReader = null;
        try {
            fileReader = new BufferedReader(new FileReader(file.getAbsoluteFile()));
            String line = null;
            while ((line = fileReader.readLine()) != null) {
                this.processLine(sql, line);
            }
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }

    private void processLine(StringBuilder sql, String line) throws IOException {
        String lowerLine = line.toLowerCase().trim();
        switch (this.stateStack.peek()) {
            case INIT: {
                if (lowerLine.startsWith(CHILD_SCRIPT_INDICATOR)) {
                    this.stateStack.pop();
                    this.stateStack.push(State.READFILE);
                    this.processLine(sql, line);
                    break;
                }
                if (!commandSet.contains(SqlFileParser.getFirstWord(lowerLine))) break;
                this.stateStack.pop();
                this.stateStack.push(State.READSQL);
                this.processLine(sql, line);
                break;
            }
            case READFILE: {
                this.stateStack.push(State.INIT);
                Resource child = this.resource.createRelative(line.replace(CHILD_SCRIPT_INDICATOR, ""));
                sql.append(this.processResource(child));
                this.stateStack.pop();
                this.stateStack.push(State.INIT);
                break;
            }
            case READSQL: {
                sql.append(line);
                sql.append(" ");
                if (!lowerLine.endsWith(";")) break;
                this.stateStack.pop();
                this.stateStack.push(State.INIT);
                break;
            }
            default: {
                throw new RuntimeException("Invalid State");
            }
        }
    }

    private static String getFirstWord(String line) {
        Matcher match = WORD_PATTERN.matcher(line);
        return match.find() ? match.group(1) : null;
    }

    static {
        commandSet.add("create");
        commandSet.add("alter");
        commandSet.add("insert");
        commandSet.add("update");
        commandSet.add("drop");
        commandSet.add("delete");
        commandSet.add("commit");
        commandSet.add("set");
        commandSet.add("truncate");
        commandSet.add("rollback");
    }

    private static enum State {
        INIT,
        READFILE,
        READSQL;

    }
}

