/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.service.LockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultLockService
implements LockService {
    private static Logger logger = LoggerFactory.getLogger(DefaultLockService.class);
    private Map<String, ReferenceTrackingLock> locks = new HashMap<String, ReferenceTrackingLock>();

    @Override
    public synchronized Lock borrowLock(String key) {
        logger.debug("BorrowLock called with key [{}]", (Object)key);
        ReferenceTrackingLock lock = this.locks.get(key);
        if (lock == null) {
            logger.debug("Existing lock not found under key [{}] - creating new lock", (Object)key);
            lock = new ReferenceTrackingLock(key);
            this.locks.put(key, lock);
        } else {
            logger.debug("Existing lock found under key [{}] - returning existing lock", (Object)key);
        }
        lock.incrementReferenceCount();
        logger.debug("Returning lock with key [{}] - and referenceCount [{}]", (Object)lock.getKey(), (Object)lock.getReferenceCount());
        return lock;
    }

    @Override
    public synchronized Lock borrowLock(String discriminator, String id) {
        if (StringUtils.isEmpty((CharSequence)discriminator)) {
            return this.borrowLock(id);
        }
        return this.borrowLock(discriminator + "-" + id);
    }

    @Override
    public synchronized void returnLock(Lock lock) {
        ReferenceTrackingLock referenceTrackingLock = (ReferenceTrackingLock)lock;
        logger.debug("Lock with key [{}] - and referenceCount [{}] has been returned", (Object)referenceTrackingLock.getKey(), (Object)referenceTrackingLock.getReferenceCount());
        referenceTrackingLock.decrementReferenceCount();
        if (referenceTrackingLock.getReferenceCount() < 1) {
            logger.debug("Lock with key [{}] - and referenceCount [{}] is being removed from service", (Object)referenceTrackingLock.getKey(), (Object)referenceTrackingLock.getReferenceCount());
            this.locks.remove(referenceTrackingLock.getKey());
        }
    }

    class ReferenceTrackingLock
    extends ReentrantLock {
        private String key;
        private volatile int referenceCount;

        private ReferenceTrackingLock(String key) {
            this.key = key;
            this.referenceCount = 0;
        }

        public String getKey() {
            return this.key;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        public void incrementReferenceCount() {
            ++this.referenceCount;
        }

        public void decrementReferenceCount() {
            --this.referenceCount;
        }
    }
}

