/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rave.model.StaticContent;
import org.apache.rave.service.StaticContentFetcherConsumer;
import org.apache.rave.service.StaticContentFetcherService;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DefaultStaticContentFetcherService
implements StaticContentFetcherService {
    private static final Log log = LogFactory.getLog(DefaultStaticContentFetcherService.class);
    private Map<String, StaticContent> contentMap;
    private RestTemplate restTemplate;
    private final Set<StaticContentFetcherConsumer> staticContentFetcherConsumers;

    public DefaultStaticContentFetcherService(RestTemplate restTemplate, List<StaticContent> contentObjects) {
        this.restTemplate = restTemplate;
        this.contentMap = new HashMap<String, StaticContent>();
        for (StaticContent contentObject : contentObjects) {
            this.contentMap.put(contentObject.getId(), contentObject);
        }
        this.staticContentFetcherConsumers = new HashSet<StaticContentFetcherConsumer>();
    }

    @Override
    public String getContent(String key) {
        log.debug((Object)("getContent(" + key + ")"));
        StaticContent content = this.contentMap.get(key);
        if (content == null) {
            throw new IllegalArgumentException("Invalid content key: " + key);
        }
        return content.getContent();
    }

    @Override
    public void refreshAll() {
        log.debug((Object)"refreshAll()");
        for (StaticContent curEntry : this.contentMap.values()) {
            this.refreshFromLocation(curEntry);
        }
    }

    @Override
    public void refresh(String key) {
        log.debug((Object)("refresh(" + key + ")"));
        StaticContent item = this.contentMap.get(key);
        if (item != null) {
            this.refreshFromLocation(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(StaticContentFetcherConsumer consumer) {
        Set<StaticContentFetcherConsumer> set = this.staticContentFetcherConsumers;
        synchronized (set) {
            log.debug((Object)("adding " + consumer.getClass().getName() + " to staticContentFetcherConsumers"));
            this.staticContentFetcherConsumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConsumer(StaticContentFetcherConsumer consumer) {
        Set<StaticContentFetcherConsumer> set = this.staticContentFetcherConsumers;
        synchronized (set) {
            log.debug((Object)("removing " + consumer.getClass().getName() + " from staticContentFetcherConsumers"));
            this.staticContentFetcherConsumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFromLocation(StaticContent staticContent) {
        log.debug((Object)("refreshFromLocation() - for " + staticContent));
        try {
            String tempContent = (String)this.restTemplate.getForObject(staticContent.getLocation(), String.class);
            for (Map.Entry<String, String> replacementTokenEntry : staticContent.getReplacementTokens().entrySet()) {
                tempContent = tempContent.replaceAll(replacementTokenEntry.getKey(), replacementTokenEntry.getValue());
            }
            staticContent.setContent(tempContent);
            Set<StaticContentFetcherConsumer> set = this.staticContentFetcherConsumers;
            synchronized (set) {
                for (StaticContentFetcherConsumer consumer : this.staticContentFetcherConsumers) {
                    log.debug((Object)("notifiying consumer " + consumer.getClass().getName() + " for content update: " + staticContent.getId()));
                    try {
                        consumer.notify(staticContent.getId());
                    }
                    catch (Exception e) {
                        log.warn((Object)"exception during consumer notification", (Throwable)e);
                    }
                }
            }
        }
        catch (RestClientException e) {
            log.error((Object)("Unable to process {" + staticContent.getLocation() + "}"), (Throwable)e);
        }
    }
}

