/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.synchronization;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.rave.service.LockService;
import org.apache.rave.synchronization.annotation.Synchronized;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SynchronizingAspect {
    private static Logger logger = LoggerFactory.getLogger(SynchronizingAspect.class);
    private LockService lockService;
    private SpelExpressionParser parser = new SpelExpressionParser();
    private ParameterNameDiscoverer paramNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private Map<Method, Expression> conditionCache = new ConcurrentHashMap<Method, Expression>();
    private Map<Method, Expression> discriminatorCache = new ConcurrentHashMap<Method, Expression>();
    private Map<Method, Expression> idCache = new ConcurrentHashMap<Method, Expression>();
    private Map<Method, Method> targetMethodCache = new ConcurrentHashMap<Method, Method>();

    @Autowired
    public SynchronizingAspect(LockService lockService) {
        this.lockService = lockService;
    }

    @Pointcut(value="@annotation(org.apache.rave.synchronization.annotation.Synchronized)")
    public void synchronizePointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="synchronizePointcut()")
    public Object synchronizeInvocation(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object target = proceedingJoinPoint.getTarget();
        Object[] args = proceedingJoinPoint.getArgs();
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
        Synchronized annotation = this.getAnnotation(targetClass, method);
        Validate.notNull((Object)annotation, (String)"Could not find @Synchronized annotation!", (Object[])new Object[0]);
        Lock lock = this.getLock(targetClass, method, args, annotation);
        if (lock == null) {
            logger.debug("No lock obtained for call [{}] on targetClass [{}] - proceeding without synchronization on thread {}", new Object[]{method.getName(), targetClass.getName(), Thread.currentThread().getId()});
            return proceedingJoinPoint.proceed();
        }
        try {
            logger.debug("Lock obtained for call [{}] on targetClass [{}] - proceeding with synchronization on thread {}", new Object[]{method.getName(), targetClass.getName(), Thread.currentThread().getId()});
            lock.lock();
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            lock.unlock();
            this.lockService.returnLock(lock);
        }
    }

    private Lock getLock(Class<?> targetClass, Method method, Object[] args, Synchronized annotation) {
        logger.debug("Fetching lock for call [{}] on targetClass [{}] with SpEl condition [{}], SpEl discriminator [{}], and SpEl id [{}] on thread {}", new Object[]{method.getName(), targetClass.getName(), annotation.condition(), annotation.discriminator(), annotation.id(), Thread.currentThread().getId()});
        EvaluationContext context = this.getEvaluationContext(targetClass, method, args);
        if (this.conditionPasses(annotation, method, context)) {
            logger.debug("Condition check passes for SpEl condition [{}] on thread {}", (Object)annotation.condition(), (Object)Thread.currentThread().getId());
            String discriminator = this.getDiscriminator(annotation, method, context);
            String id = this.getId(annotation, method, context);
            logger.debug("Fetching lock with discriminator [{}] and id [{}] on thread {}", new Object[]{discriminator, id, Thread.currentThread().getId()});
            return this.lockService.borrowLock(discriminator, id);
        }
        logger.debug("Condition check fails for SpEl condition [{}] on thread {}", (Object)annotation.condition(), (Object)Thread.currentThread().getId());
        return null;
    }

    private boolean conditionPasses(Synchronized annotation, Method method, EvaluationContext context) {
        String condition = annotation.condition();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            return (Boolean)this.parseConditionExpression(method, annotation).getValue(context, Boolean.class);
        }
        return true;
    }

    private String getDiscriminator(Synchronized annotation, Method method, EvaluationContext context) {
        return (String)this.parseDiscriminatorExpression(method, annotation).getValue(context, String.class);
    }

    private String getId(Synchronized annotation, Method method, EvaluationContext context) {
        return (String)this.parseIdExpression(method, annotation).getValue(context, String.class);
    }

    private Expression parseConditionExpression(Method method, Synchronized annotation) {
        Expression expression = this.conditionCache.get(method);
        if (expression == null) {
            expression = this.parser.parseExpression(annotation.condition());
            this.conditionCache.put(method, expression);
        }
        return expression;
    }

    private Expression parseDiscriminatorExpression(Method method, Synchronized annotation) {
        Expression expression = this.discriminatorCache.get(method);
        if (expression == null) {
            expression = this.parser.parseExpression(annotation.discriminator());
            this.discriminatorCache.put(method, expression);
        }
        return expression;
    }

    private Expression parseIdExpression(Method method, Synchronized annotation) {
        Expression expression = this.idCache.get(method);
        if (expression == null) {
            expression = this.parser.parseExpression(annotation.id());
            this.idCache.put(method, expression);
        }
        return expression;
    }

    private Method getTargetMethod(Class<?> targetClass, Method method) {
        Method targetMethod = this.targetMethodCache.get(method);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
            this.targetMethodCache.put(method, targetMethod);
        }
        return targetMethod;
    }

    private EvaluationContext getEvaluationContext(Class<?> targetClass, Method method, Object[] args) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (ArrayUtils.isEmpty((Object[])args)) {
            return context;
        }
        Method targetMethod = this.getTargetMethod(targetClass, method);
        for (int i = 0; i < args.length; ++i) {
            context.setVariable("p" + i, args[i]);
        }
        String[] parameterNames = this.paramNameDiscoverer.getParameterNames(targetMethod);
        if (parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                context.setVariable(parameterNames[i], args[i]);
            }
        }
        return context;
    }

    private Synchronized getAnnotation(Class<?> targetClass, Method method) {
        Method specificMethod = this.getTargetMethod(targetClass, method);
        return (Synchronized)AnnotationUtils.getAnnotation((Method)specificMethod, Synchronized.class);
    }
}

