/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T, K> void reconcileObjectCollections(Collection<T> existingCollection, Collection<T> updatedCollection, CollectionReconciliationHelper<T, K> reconciliationHelper, boolean removeMissingObjects) {
        Validate.noNullElements(existingCollection);
        Validate.noNullElements(updatedCollection);
        HashMap<K, T> existingObjects = new HashMap<K, T>(existingCollection.size());
        HashMap<K, T> updatedObjects = new HashMap<K, T>(updatedCollection.size());
        for (T t : updatedCollection) {
            updatedObjects.put(reconciliationHelper.extractKey(t), t);
        }
        Iterator<T> iterator = existingCollection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            Object updatedObject = updatedObjects.get(reconciliationHelper.extractKey(t));
            if (updatedObject == null) {
                if (!removeMissingObjects) continue;
                iterator.remove();
                continue;
            }
            reconciliationHelper.reconcileValues(t, updatedObject);
            existingObjects.put(reconciliationHelper.extractKey(t), t);
        }
        for (Map.Entry entry : updatedObjects.entrySet()) {
            if (existingObjects.containsKey(entry.getKey())) continue;
            existingCollection.add(entry.getValue());
        }
    }

    public static <T> List<T> toBaseTypedList(List<? extends T> initial) {
        return initial;
    }

    public static <T> Collection<T> toBaseTypedCollection(Collection<? extends T> initial) {
        return initial;
    }

    public static <T> void addUniqueValues(List<T> source, List<T> target) {
        for (T item : source) {
            if (target.contains(item)) continue;
            target.add(item);
        }
    }

    public static <T> T getSingleValue(List<T> list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new IllegalArgumentException("Expected 0 or 1 items in the collection but found " + list.size());
    }

    public static interface CollectionReconciliationHelper<T, K> {
        public K extractKey(T var1);

        public void reconcileValues(T var1, T var2);
    }
}

