/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.mrbean.MrBeanModule;
import java.io.IOException;
import org.springframework.core.io.Resource;

public class JsonUtils {
    private JsonUtils() {
    }

    public static <T> String stringify(T object) {
        try {
            return JsonUtils.getMapper().writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String serialized, Class<T> klass) {
        try {
            return (T)(serialized == null ? null : JsonUtils.getMapper().readValue(serialized, klass));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(Resource resource, Class<T> klass) {
        try {
            return (T)JsonUtils.getMapper().readValue(resource.getFile(), klass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ObjectMapper getMapper() {
        ObjectMapper jacksonMapper = new ObjectMapper();
        JacksonAnnotationIntrospector primary = new JacksonAnnotationIntrospector();
        jacksonMapper.setAnnotationIntrospector((AnnotationIntrospector)primary);
        jacksonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jacksonMapper.registerModule((Module)new MrBeanModule());
        return jacksonMapper;
    }
}

